/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.hxb.request.merchant;

import com.fshows.hxb.request.HxbpayBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;

/**
 * 说明：此次请求中表示是否语义的字段皆是 Y:是  N:否
 *
 * @author zhengfangquan
 * @version Test.java, v 0.1 2024-7-25 下午4:20 zhengfangquan
 */
@Data
public class HxbMerchantIncomeReq extends HxbpayBizReq {


    private static final long serialVersionUID = 7096305644729315265L;

    /**
     * 系统流水号
     */
    private String systemNo;

    /**
     * 系统交易码
     * PAY001
     */
    @NotBlank(message = "tranTrace不能为空")
    private String tranTrace;

    /**
     * 进件id
     */
    @Length(max = 32, message = "id长度不合法")
    @NotBlank(message = "id不能为空")
    private String id;

    /**
     * 商户异步通知地址
     */
    @Length(max = 100, message = "sslUrl长度不合法")
    @NotBlank(message = "sslUrl不能为空")
    private String sslUrl;

    /**
     * 一级服务商编号
     */
    @Length(max = 20, message = "parentServerorgno长度不合法")
    @NotBlank(message = "parentServerorgno不能为空")
    private String parentServerorgno;

    /**
     * 二级服务商机构编码
     */
    @Length(max = 20, message = "serverOrgNo长度不合法")
    @NotBlank(message = "serverOrgNo不能为空")
    private String serverOrgNo;

    /**
     * 是否小微商户
     * Y 是
     * N 否
     */
    @Length(max = 2, message = "smallmacroMerchantFlag长度不合法")
    @NotBlank(message = "smallmacroMerchantFlag不能为空")
    private String smallmacroMerchantFlag;

    /**
     * 布放类型
     * 1 直联
     * 0 间联
     */
    @Length(max = 2, message = "layoutType长度不合法")
    @NotBlank(message = "layoutType不能为空")
    private String layoutType;

    /**
     * 商户名称
     */
    @Length(max = 60, message = "merchantName长度不合法")
    @NotBlank(message = "merchantName不能为空")
    private String merchantName;

    /**
     * 终端打印名称
     */
    @Length(max = 40, message = "merchantAbbreviation长度不合法")
    @NotBlank(message = "merchantAbbreviation不能为空")
    private String merchantAbbreviation;

    /**
     * 商户类型
     * 01 宾馆酒店
     * 02 商场
     * 03 个体
     * 04 财务
     */
    @Length(max = 2, message = "merchantType长度不合法")
    @NotBlank(message = "merchantType不能为空")
    private String merchantType;

    /**
     * 营业证明类型
     * 是否小微商户（不是小微商户必输）
     * 01 营业执照
     * 02 事业单位法人证书
     * 04 其他证明文件
     * 05 统一社会信用代码证书
     * 06 有偿服务许可证
     * 07 企业营业执照
     * 08 组织机构代码证
     * 09 社会团体法人登记证书
     * 10 民办非企业单位登记证书
     * 11 基金会法人登记证书
     * 12 慈善组织公开募捐资格证书
     * 13 农民专业合作社法人营业执照
     * 14 宗教活动场所登记证
     */
    @Length(max = 2, message = "businessCertificateType长度不合法")
    private String businessCertificateType;

    /**
     * 营业证明号码
     * 是否小微商户（不是小微商户必输）
     */
    @Length(max = 30, message = "businessCertificateNumber长度不合法")
    private String businessCertificateNumber;

    /**
     * 营业证明是否长期有效
     * 是否小微商户（不是小微商户必输）、营业证明不是长期有效必输
     */
    @Length(max = 2, message = "permanentFlag长度不合法")
    private String permanentFlag;

    /**
     * 营业证明有效期起
     * 是否小微商户（不是小微商户必输）
     */
    @Length(max = 14, message = "businessCertificateValidSt长度不合法")
    private String businessCertificateValidSt;

    /**
     * 营业证明有效期止
     * 是否小微商户（不是小微商户必输）
     */
    @Length(max = 14, message = "businessCertificateValidEd长度不合法")
    private String businessCertificateValidEd;

    /**
     * 税务登记号码
     * 是否小微商户（不是小微商户必输）
     */
    @Length(max = 30, message = "taxRegisterCertificate长度不合法")
    private String taxRegisterCertificate;

    /**
     * 组织机构代码
     */
    @Length(max = 30, message = "orgCodeCertificate长度不合法")
    private String orgCodeCertificate;

    /**
     * 租赁合同到期时间
     */
    @Length(max = 14, message = "leaseContractDeadline长度不合法")
    private String leaseContractDeadline;

    /**
     * 营业范围
     * 是否小微商户（不是小微商户必输）
     */
    @Length(max = 2000, message = "businessRange长度不合法")
    private String businessRange;

    /**
     * 法人代表姓名
     */
    @Length(max = 30, message = "corporationName长度不合法")
    @NotBlank(message = "corporationName不能为空")
    private String corporationName;

    /**
     * 法人证件类型
     * 51	居民第二代身份证
     * 76	外国人永久居留证
     * 55	港澳居民往来内地通行证
     * 69	台湾居民来往大陆通行证
     * 67	港澳居民居住证
     * 68	台湾居民居住证
     * 73	中国护照
     * 52	外国护照
     */
    @Length(max = 2, message = "corporationCredentialType长度不合法")
    @NotBlank(message = "corporationCredentialType不能为空")
    private String corporationCredentialType;

    /**
     * 法人证件号码
     */
    @Length(max = 30, message = "corporationCredentialNumber长度不合法")
    @NotBlank(message = "corporationCredentialNumber不能为空")
    private String corporationCredentialNumber;

    /**
     * 法人证件是否长期有效
     * Y 是
     * N 否
     */
    @Length(max = 2, message = "corporationFlag长度不合法")
    @NotBlank(message = "corporationFlag不能为空")
    private String corporationFlag;

    /**
     * 法人联系电话
     */
    @Length(max = 30, message = "corporationPhone长度不合法")
    @NotBlank(message = "corporationPhone不能为空")
    private String corporationPhone;

    /**
     * 法人证件有效期起
     * 例：2021-06-21
     */
    @Length(max = 14, message = "credentialValidStart长度不合法")
    @NotBlank(message = "credentialValidStart不能为空")
    private String credentialValidStart;

    /**
     * 法人证件有效期止
     * 法人证明不是长期有效必输
     */
    @Length(max = 14, message = "credentialValidEnd长度不合法")
    private String credentialValidEnd;

    /**
     * 授权业务处理人
     */
    @Length(max = 30, message = "contacts长度不合法")
    @NotBlank(message = "contacts不能为空")
    private String contacts;

    /**
     * 授权业务处理人手机号
     */
    @Length(max = 30, message = "contactsPhone长度不合法")
    @NotBlank(message = "contactsPhone不能为空")
    private String contactsPhone;

    /**
     * 授权业务办理人员国籍(中文)
     */
    @Length(max = 30, message = "contactsNationalityCn长度不合法")
    private String contactsNationalityCn;

    /**
     * 授权业务办理人员国籍(英文)
     */
    @Length(max = 10, message = "contactsNationalityEn长度不合法")
    private String contactsNationalityEn;

    /**
     * 授权业务办理人员证件类型
     */
    @Length(max = 2, message = "contactsCredentialType长度不合法")
    private String contactsCredentialType;

    /**
     * 授权业务办理人证件号码
     */
    @Length(max = 30, message = "contactIdCard长度不合法")
    private String contactIdCard;

    /**
     * 授权业务办理人员证件是否长期有效
     * Y 是
     * N 否
     */
    @Length(max = 2, message = "contactsFlag长度不合法")
    private String contactsFlag;

    /**
     * 授权业务办理人员证件有效期起
     */
    @Length(max = 14, message = "contactsValidStart长度不合法")
    private String contactsValidStart;

    /**
     * 授权业务办理人员证件有效期止
     */
    @Length(max = 14, message = "contactsValidEnd长度不合法")
    private String contactsValidEnd;

    /**
     * 商户注册地址
     */
    @Length(max = 90, message = "registerAddress长度不合法")
    private String registerAddress;

    /**
     * 商户实际经营地址省
     */
    @Length(max = 6, message = "actualProvince长度不合法")
    @NotBlank(message = "actualProvince不能为空")
    private String actualProvince;

    /**
     * 商户实际经营地址市
     */
    @Length(max = 6, message = "actualCity长度不合法")
    @NotBlank(message = "actualCity不能为空")
    private String actualCity;

    /**
     * 商户实际经营地址地区
     */
    @Length(max = 6, message = "actualArea长度不合法")
    @NotBlank(message = "actualArea不能为空")
    private String actualArea;

    /**
     * 商户实际经营地址详细地址
     */
    @Length(max = 60, message = "actualAddress长度不合法")
    @NotBlank(message = "actualAddress不能为空")
    private String actualAddress;

    /**
     * 商户位置
     */
    @Length(max = 30, message = "merchantLocation长度不合法")
    private String merchantLocation;

    /**
     * 账户类型
     * 0 本行对公户
     * 1 本行对私户
     * 2 本行单位结算卡
     * 3 他行对公户
     * 4 他行对私户
     */
    @Length(max = 2, message = "accountType长度不合法")
    private String accountType;

    /**
     * 结算卡号
     * 1本行对私户必填
     */
    @Length(max = 20, message = "transferAccount长度不合法")
    private String transferAccount;

    /**
     * 结算账号
     * 0本行对公户、2本行单位结算卡必填
     */
    @Length(max = 20, message = "settlementAccount长度不合法")
    private String settlementAccount;

    /**
     * 结算支行
     */
    @Length(max = 19, message = "settlementBranch长度不合法")
    private String settlementBranch;

    /**
     * 商户负责人是否卷入法律诉讼
     */
    @Length(max = 1, message = "legalProceedFlag长度不合法")
    @NotBlank(message = "legalProceedFlag不能为空")
    private String legalProceedFlag;

    /**
     * 商户是否卷入法律诉讼
     */
    @Length(max = 1, message = "merchantLegalProceedFlag长度不合法")
    @NotBlank(message = "merchantLegalProceedFlag不能为空")
    private String merchantLegalProceedFlag;

    /**
     * 法人是否其他卡组织不良持卡人
     */
    @Length(max = 1, message = "badCardholderFlag长度不合法")
    @NotBlank(message = "badCardholderFlag不能为空")
    private String badCardholderFlag;

    /**
     * 是否有债务逾期
     */
    @Length(max = 1, message = "overdueDebtFlag长度不合法")
    private String overdueDebtFlag;

    /**
     * 商户是否被收单行拒绝
     */
    @Length(max = 1, message = "acquiringBankRefuseFlag长度不合法")
    private String acquiringBankRefuseFlag;

    /**
     * 商户是否其他卡组织可疑商户
     */
    @Length(max = 1, message = "ventureMerchantFlag长度不合法")
    @NotBlank(message = "ventureMerchantFlag不能为空")
    private String ventureMerchantFlag;

    /**
     * 是否对接综合支付
     */
    @Length(max = 2, message = "joinZhzf长度不合法")
    @NotBlank(message = "joinZhzf不能为空")
    private String joinZhzf;

    /**
     * 支持交易接口
     * 是否对接综合支付(选择是必输)数据格式
     * 00订单查询接口
     * 01主扫下单接口
     * 02订单撤销接口
     * 03订单退货接口
     * 04被扫支付接口
     * 05支付宝预下单接口
     * 06支付宝订单创建接口
     * 07微信预下单接口
     * 09数字货币主扫支付接口,数字货币订单关闭接口
     * 10银联JS支付接口
     */
    @Length(max = 65, message = "transactionInterface长度不合法")
    private String transactionInterface;

    /**
     * 授权目录
     */
    @Length(max = 200, message = "authorizationDirectory长度不合法")
    private String authorizationDirectory;

    /**
     * 绑定公众号
     */
    @Length(max = 100, message = "bindAppid长度不合法")
    private String bindAppid;

    /**
     * 是否开通微信
     */
    @Length(max = 2, message = "wechatFlag长度不合法")
    @NotBlank(message = "wechatFlag不能为空")
    private String wechatFlag;

    /**
     * 微信商户名称
     * 开通微信时必输
     */
    @Length(max = 100, message = "wechatMerchantName长度不合法")
    private String wechatMerchantName;

    /**
     * 微信商户简称
     * 开通微信时必输
     */
    @Length(max = 40, message = "wxShortName长度不合法")
    private String wxShortName;

    /**
     * 微信支付渠道
     * 开通微信时必输
     * 01总行
     * 03厦门
     * 05长春分行生活缴费
     * 06收钱吧
     */
    @Length(max = 32, message = "channelWechat长度不合法")
    private String channelWechat;

    /**
     * 是否开通支付宝
     */
    @Length(max = 2, message = "alipayFlag长度不合法")
    @NotBlank(message = "alipayFlag不能为空")
    private String alipayFlag;

    /**
     * 地址省
     * 开通支付宝时必输
     */
    @Length(max = 6, message = "aliProvince长度不合法")
    private String aliProvince;

    /**
     * 地址市
     * 开通支付宝时必输
     */
    @Length(max = 6, message = "aliCity长度不合法")
    private String aliCity;

    /**
     * 地址区
     * 开通支付宝时必输
     */
    @Length(max = 6, message = "aliArea长度不合法")
    private String aliArea;

    /**
     * 地址类型
     * 开通支付宝时必输
     * 01 经营地址
     * 02 注册地址
     */
    @Length(max = 2, message = "alipayAddrType长度不合法")
    private String alipayAddrType;

    /**
     * 是否开通支付宝线下特殊费率
     * 开通支付宝时必输
     */
    @Length(max = 2, message = "aliSpFeeFlag长度不合法")
    private String aliSpFeeFlag;

    /**
     * 活动类型
     * 开通支付宝时必输
     * INDUSTRY_SPECIAL 特殊行业优惠费率
     */
    @Length(max = 16, message = "activityType长度不合法")
    private String activityType;

    /**
     * 是否开通银联二维码
     */
    @Length(max = 2, message = "unionpayQrcodeFlag长度不合法")
    @NotBlank(message = "unionpayQrcodeFlag不能为空")
    private String unionpayQrcodeFlag;

    /**
     * 是否开通银联云闪付
     */
    @Length(max = 2, message = "cloudOpenFlag长度不合法")
    @NotBlank(message = "cloudOpenFlag不能为空")
    private String cloudOpenFlag;

    /**
     * 是否开通转账
     */
    @Length(max = 2, message = "transferFlag长度不合法")
    @NotBlank(message = "transferFlag不能为空")
    private String transferFlag;

    /**
     * 本行卡扣率类型
     * 1 百分比
     * 2 固定费用
     * 3 分段收费
     */
    @Length(max = 1, message = "ownCardRebateRate长度不合法")
    @NotBlank(message = "ownCardRebateRate不能为空")
    private String ownCardRebateRate;

    /**
     * 本行卡第一级费率-类型
     * 本行卡扣率类型为2时，只能是F固定费用；
     * 本行卡扣率类型为3时，可选F或者P；
     * 本行卡扣率类型为1时，只能是P按百分比
     * F固定费用
     * P按百分比
     */
    @Length(max = 1, message = "ownFirstFeeRateType长度不合法")
    @NotBlank(message = "ownFirstFeeRateType不能为空")
    private String ownFirstFeeRateType;

    /**
     * 本行卡第一级费率-数值
     * 行卡一级费率类型为F时，填XX.XX元；
     * 本行卡一级费率类型为P时，填XX%
     */
    @Length(max = 9, message = "ownFirstFeeRateNum长度不合法")
    @NotBlank(message = "ownFirstFeeRateNum不能为空")
    private String ownFirstFeeRateNum;

    /**
     * 本行卡一级交易限额
     * 本行卡扣率类型为3时必输，限额不能为0且最多支持6位整数
     */
    @Length(max = 10, message = "ownFirstFeeLimit长度不合法")
    private String ownFirstFeeLimit;

    /**
     * 本行卡第二级费率-类型
     * 本行卡扣率类型为3时必输
     */
    @Length(max = 1, message = "ownSecondFeeRateType长度不合法")
    private String ownSecondFeeRateType;

    /**
     * 本行卡第二级费率-数值
     * 本行卡一级费率类型为F时，填XX.XX元；
     * 本行卡一级费率类型为P时，填XX%
     */
    @Length(max = 9, message = "ownSecondFeeRateNum长度不合法")
    private String ownSecondFeeRateNum;

    /**
     * 他行借记卡扣率类型
     * 1 百分比
     * 2 固定费用
     * 3 分段收费
     */
    @Length(max = 1, message = "otherDebitRebateType长度不合法")
    private String otherDebitRebateType;

    /**
     * 他行借记卡第一级费率-类型
     * 他行借记卡扣率类型为2时，只能是F固定费用；
     * 他行借记卡扣率类型为3时，可选F或者P；
     * 他行借记卡扣率类型为1时，只能是P按百分比
     */
    @Length(max = 1, message = "otherDebitFirstFeeRateType长度不合法")
    private String otherDebitFirstFeeRateType;

    /**
     * 他行借记卡第一级费率-数值
     * 他行借记卡一级费率类型为F时，填XX.XX元；
     * 他行借记卡一级费率类型为P时，填XX%
     */
    @Length(max = 9, message = "otherDebitFirstFeeRateNum长度不合法")
    private String otherDebitFirstFeeRateNum;

    /**
     * 他行借记卡一级交易限额
     * 他行借记卡扣率类型为3时必输，限额不能为0且最多支持6位整数
     */
    @Length(max = 10, message = "otherDebitFirstFeeLimit长度不合法")
    private String otherDebitFirstFeeLimit;

    /**
     * 他行借记卡第二级费率-类型
     * 他行借记卡扣率类型为3时必输
     */
    @Length(max = 1, message = "otherDebitSecondFeeRateType长度不合法")
    private String otherDebitSecondFeeRateType;

    /**
     * 他行借记卡第二级费率-数值
     * 他行借记卡一级费率类型为F时，填XX.XX元；
     * 他行借记卡一级费率类型为P时，填XX
     */
    @Length(max = 9, message = "otherDebitSecondFeeRateNum长度不合法")
    private String otherDebitSecondFeeRateNum;

    /**
     * 他行贷记卡扣率类型
     */
    @Length(max = 1, message = "otherCreditRebateType长度不合法")
    private String otherCreditRebateType;

    /**
     * 他行贷记卡第一级费率-类型
     */
    @Length(max = 1, message = "otherCreditFirstFeeRateType长度不合法")
    private String otherCreditFirstFeeRateType;

    /**
     * 他行贷记卡第一级费率-数值
     */
    @Length(max = 9, message = "otherCreditFirstFeeRateNum长度不合法")
    private String otherCreditFirstFeeRateNum;

    /**
     * 他行贷记卡一级交易限额
     */
    @Length(max = 10, message = "otherCreditFirstFeeLimit长度不合法")
    private String otherCreditFirstFeeLimit;

    /**
     * 他行贷记卡第二级费率-类型
     */
    @Length(max = 1, message = "otherCreditSecondFeeRateType长度不合法")
    private String otherCreditSecondFeeRateType;

    /**
     * 他行贷记卡第二级费率-数值
     */
    @Length(max = 9, message = "otherCreditSecondFeeRateNum长度不合法")
    private String otherCreditSecondFeeRateNum;

    /**
     * 银联云闪付借记卡扣率类型（含银联扫码支付）
     */
    @Length(max = 10, message = "cloudDebitRebateType长度不合法")
    private String cloudDebitRebateType;

    /**
     * 银联云闪付借记卡第一级费率-类型
     */
    @Length(max = 1, message = "cloudDebitFirstFeeRateType长度不合法")
    private String cloudDebitFirstFeeRateType;

    /**
     * 银联云闪付借记卡第一级费率-数值
     */
    @Length(max = 9, message = "cloudDebitFirstFeeRateNum长度不合法")
    private String cloudDebitFirstFeeRateNum;

    /**
     * 银联云闪付借记卡一级交易限额
     */
    @Length(max = 10, message = "cloudDebitFirstFeeLimit长度不合法")
    private String cloudDebitFirstFeeLimit;

    /**
     * 银联云闪付借记卡第二级费率-类型
     */
    @Length(max = 1, message = "cloudDebitSecondFeeRateType长度不合法")
    private String cloudDebitSecondFeeRateType;

    /**
     * 银联云闪付借记卡第二级费率-数值
     */
    @Length(max = 9, message = "cloudDebitSecondFeeRateNum长度不合法")
    private String cloudDebitSecondFeeRateNum;

    /**
     * 银联云闪付贷记卡优惠费率（含银联扫码支付）
     * 开通银联云闪付时必输，最多支持2位整数（含0）、2位小数
     */
    @Length(max = 10, message = "cloudCreditFirstFeeRate长度不合法")
    private String cloudCreditFirstFeeRate;

    /**
     * 微信手续费费率
     * 开通银联云闪付时必输，最多支持2位整数（含0）、2位小数
     */
    @Length(max = 10, message = "wechatFeeRate长度不合法")
    private String wechatFeeRate;

    /**
     * 支付宝手续费费率
     * 开通银联云闪付时必输，最多支持2位整数（含0）、2位小数
     */
    @Length(max = 10, message = "alipayFeeRate长度不合法")
    private String alipayFeeRate;

    /**
     * POS借记卡单笔交易限额
     * 最多支持9位整数（含0）、2位小数
     */
    @Length(max = 18, message = "debitSingleFeeLimit长度不合法")
    @NotBlank(message = "debitSingleFeeLimit不能为空")
    private String debitSingleFeeLimit;

    /**
     * POS借记卡日累计交易限额
     * 最多支持9位整数（含0）、2位小数
     */
    @Length(max = 18, message = "debitDailyFeeLimit长度不合法")
    @NotBlank(message = "debitDailyFeeLimit不能为空")
    private String debitDailyFeeLimit;

    /**
     * POS贷记卡单笔交易限额
     * 最多支持9位整数（含0）、2位小数
     */
    @Length(max = 18, message = "creditSingleFeeLimit长度不合法")
    @NotBlank(message = "creditSingleFeeLimit不能为空")
    private String creditSingleFeeLimit;

    /**
     * POS贷记卡日累计交易限额
     * 最多支持9位整数（含0）、2位小数
     */
    @Length(max = 18, message = "creditDailyFeeLimit长度不合法")
    @NotBlank(message = "creditDailyFeeLimit不能为空")
    private String creditDailyFeeLimit;

    /**
     * 银行卡消费日累计笔数
     * 最多支持1~999999999之间的数字
     */
    @Length(max = 10, message = "cardDailyCumulativeNumber长度不合法")
    @NotBlank(message = "cardDailyCumulativeNumber不能为空")
    private String cardDailyCumulativeNumber;

    /**
     * 银行卡消费日累计金额
     * 最多支持9位整数（含0）、2位小数
     */
    @Length(max = 12, message = "cardDailyCumulativeFee长度不合法")
    @NotBlank(message = "cardDailyCumulativeFee不能为空")
    private String cardDailyCumulativeFee;

    /**
     * 银行卡消费月累计笔数
     */
    @Length(max = 12, message = "cardMonthlyCumulativeNumber长度不合法")
    @NotBlank(message = "cardMonthlyCumulativeNumber不能为空")
    private String cardMonthlyCumulativeNumber;

    /**
     * 银行卡消费月累计金额
     */
    @Length(max = 12, message = "cardMonthlyCumulativeFee长度不合法")
    @NotBlank(message = "cardMonthlyCumulativeFee不能为空")
    private String cardMonthlyCumulativeFee;

    /**
     * 银行卡消费年累计笔数
     */
    @Length(max = 12, message = "cardAnnualCumulativeNumber长度不合法")
    @NotBlank(message = "cardAnnualCumulativeNumber不能为空")
    private String cardAnnualCumulativeNumber;

    /**
     * 银行卡消费年累计金额
     * 最多支持11位整数（含0）、2位小数,需大于等于月累计金额
     */
    @Length(max = 18, message = "cardAnnualCumulativeFee长度不合法")
    @NotBlank(message = "cardAnnualCumulativeFee不能为空")
    private String cardAnnualCumulativeFee;

    /**
     * 微信消费单笔交易限额
     * 开通微信时必输
     * 最多支持7位整数（含0）、2位小数
     */
    @Length(max = 10, message = "wechatSingleFeeLimit长度不合法")
    private String wechatSingleFeeLimit;

    /**
     * 微信日累计交易限额
     * 开通微信时必输
     * 最多支持7位整数（含0）、2位小数，必须大于等于单笔交易限额
     */
    @Length(max = 10, message = "wechatDailyFeeLimit长度不合法")
    private String wechatDailyFeeLimit;

    /**
     * 微信月累计交易限额
     * 开通微信时必输
     * 最多支持9位整数（含0）、2位小数，并且须大于等于微信日累计交易限额
     */
    @Length(max = 12, message = "wechatMonthlyFeeLimit长度不合法")
    private String wechatMonthlyFeeLimit;

    /**
     * 支付宝消费单笔交易限额
     * 开通支付宝时必输
     * 最多支持9位整数（含0）、2位小数
     */
    @Length(max = 12, message = "alipaySingleFeeLimit长度不合法")
    private String alipaySingleFeeLimit;

    /**
     * 支付宝日累计交易限额
     * 开通支付宝时必输
     * 最多支持9位整数（含0）、2位小数，日累计交易限额须大于等于支付宝消费单笔交易限额
     */
    @Length(max = 12, message = "alipayDailyFeeLimit长度不合法")
    private String alipayDailyFeeLimit;

    /**
     * 支付宝月累计交易限额
     * 开通支付宝时必输
     * 最多支持9位整数（含0）、2位小数，月累计交易限额须大于等于支付宝日累计交易限额
     */
    @Length(max = 12, message = "alipayMonthlyFeeLimit长度不合法")
    private String alipayMonthlyFeeLimit;

    /**
     * 银联扫码消费单笔交易限额
     * 开通银联二维码时必输
     * 单笔交易限额为小于20000的整数
     */
    @Length(max = 12, message = "unionpaySingleFeeLimit长度不合法")
    private String unionpaySingleFeeLimit;

    /**
     * 银联扫码日累计交易限额
     * 开通银联二维码时必输
     * 最多支持9位整数（含0）、2位小数，日累计交易限额须大于等于银联扫码单笔交易限额
     */
    @Length(max = 12, message = "unionpayDailyFeeLimit长度不合法")
    private String unionpayDailyFeeLimit;

    /**
     * 银联扫码月累计交易限额
     * 开通银联二维码时必输
     * 最多支持9位整数（含0）、2位小数，月累计交易限额须大于等于银联扫码日累计交易限额
     */
    @Length(max = 12, message = "unionpayMonthlyFeeLimit长度不合法")
    private String unionpayMonthlyFeeLimit;

    /**
     * 扫码支付消费日累计笔数
     */
    @Length(max = 10, message = "scanDailyCumulativeNumber长度不合法")
    private String scanDailyCumulativeNumber;

    /**
     * 扫码支付消费日累计金额
     * 开通银联二维码时必输
     * 最多支持11位整数（含0）、2位小数，扫码支付消费日累计金额须大于等于[微信、支付宝、
     * 银联扫码]日累计交易限额中的最大值扫码支付消费日累计金额须大于等于[微信、支付宝、银联扫码]
     * 日累计交易限额中的最大值
     */
    @Length(max = 18, message = "scanDailyCumulativeFee长度不合法")
    private String scanDailyCumulativeFee;

    /**
     * 扫码支付消费月累计笔数
     */
    @Length(max = 10, message = "scanMonthlyCumulativeNumber长度不合法")
    private String scanMonthlyCumulativeNumber;

    /**
     * 扫码支付消费月累计金额
     */
    @Length(max = 18, message = "scanMonthlyCumulativeFee长度不合法")
    private String scanMonthlyCumulativeFee;

    /**
     * 扫码支付消费年累计笔数
     */
    @Length(max = 10, message = "scanAnnualCumulativeNumber长度不合法")
    private String scanAnnualCumulativeNumber;

    /**
     * 扫码支付消费年累计金额
     */
    @Length(max = 18, message = "scanAnnualCumulativeFee长度不合法")
    private String scanAnnualCumulativeFee;

    /**
     * 银联卡卡转账单笔转账限额
     */
    @Length(max = 12, message = "unionSingleTransferLimit长度不合法")
    private String unionSingleTransferLimit;

    /**
     * 银联卡卡转账单日累计转账限额
     */
    @Length(max = 12, message = "unionDailyTransferLimit长度不合法")
    private String unionDailyTransferLimit;

    /**
     * 大额及网银单笔转账限额
     */
    @Length(max = 18, message = "ebankSingleTransferLimit长度不合法")
    private String ebankSingleTransferLimit;

    /**
     * 大额及网银单日累计转账限额
     */
    @Length(max = 18, message = "ebankDailyTransferLimit长度不合法")
    private String ebankDailyTransferLimit;

    /**
     * 日累计转账笔数
     */
    @Length(max = 10, message = "dailyTransferNumber长度不合法")
    private String dailyTransferNumber;

    /**
     * 日累计转账金额
     */
    @Length(max = 12, message = "dailyTransferFee长度不合法")
    private String dailyTransferFee;

    /**
     * 月累计转账笔数
     */
    @Length(max = 10, message = "monthlyTransferNumber长度不合法")
    private String monthlyTransferNumber;

    /**
     * 月累计转账金额
     */
    @Length(max = 18, message = "monthlyTransferFee长度不合法")
    private String monthlyTransferFee;

    /**
     * 年累计转账笔数
     */
    @Length(max = 10, message = "annualTransferNumber长度不合法")
    private String annualTransferNumber;

    /**
     * 年累计转账金额
     */
    @Length(max = 18, message = "annualTransferFee长度不合法")
    private String annualTransferFee;

    /**
     * 小微商户贷记支付日累计限额
     */
    @Length(max = 12, message = "smallMacroSmcDayLimit长度不合法")
    private String smallMacroSmcDayLimit;

    /**
     * 小微商户贷记支付月累计限额
     */
    @Length(max = 12, message = "smallMacroSmcMonthLimit长度不合法")
    private String smallMacroSmcMonthLimit;

    /**
     * 服务商机构标识码PID
     * 银联为服务商分配的ID
     */
    @Length(max = 11, message = "pnrInsIdCd长度不合法")
    private String pnrInsIdCd;

    /**
     * 微信支付宝入账类型
     * 账户类型”字段选择“本行对公户”、“本行对私户”、“本行单位结算卡”时，
     * 该字段必填；商户类型为“宾馆酒店”、“商场”、“个体”时，该字段必填
     * 0:T+1
     * 1:D+1
     */
    @Length(max = 1, message = "dayAddOneFlag长度不合法")
    private String dayAddOneFlag;

    /**
     * 数字货币是否开通
     */
    @Length(max = 1, message = "dcFlag长度不合法")
    private String dcFlag;

    /**
     * 数字货币业务种类
     * <p>
     * 2030：服装类消费
     * 2031：饰品类消费
     * 2032：家居类消费
     * 2033：生活类消费
     * 2034：食品类消费
     * 2035：虚拟类消费
     * 2036：机票类消费
     * 2037：旅游类消费
     * 2038：美容类消费
     * 2039：数码类消费
     * 2040：电器类消费
     * 2041：文体类消费
     * 2042：酒店类消费
     * 2043：其他类消费
     */
    @Length(max = 4, message = "dcBizType长度不合法")
    private String dcBizType;

    /**
     * 数字货币单笔限额
     */
    @Length(max = 12, message = "dcSingleFeeLimit长度不合法")
    private String dcSingleFeeLimit;

    /**
     * 数字货币日累计限额
     */
    @Length(max = 12, message = "dcDailyFeeLimit长度不合法")
    private String dcDailyFeeLimit;

    /**
     * 数字货币月累计限额
     */
    @Length(max = 12, message = "dcMonthFeeLimit长度不合法")
    private String dcMonthFeeLimit;

    /**
     * 数字货币年累计限额
     */
    @Length(max = 12, message = "dcYearFeeLimit长度不合法")
    private String dcYearFeeLimit;

    /**
     * 数字货币日累计笔数
     */
    @Length(max = 10, message = "dcDailyFeeNumber长度不合法")
    private String dcDailyFeeNumber;

    /**
     * 数字货币月累计笔数
     */
    @Length(max = 10, message = "dcMonthFeeNumber长度不合法")
    private String dcMonthFeeNumber;

    /**
     * 数字货币年累计笔数
     */
    @Length(max = 10, message = "dcYearFeeNumber长度不合法")
    private String dcYearFeeNumber;

    /**
     * 服务商商户ID
     */
    @Length(max = 32, message = "serverMerchantId长度不合法")
    private String serverMerchantId;

    /**
     * 备注
     */
    @Length(max = 400, message = "reMarks长度不合法")
    private String reMarks;


}