/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fuiou.client.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.fuiou.client.base.ApiClientConfig;
import com.fshows.fuiou.client.base.ISigner;
import com.fshows.fuiou.client.base.SignParam;
import com.fshows.fuiou.client.base.VerifySignParam;
import com.fshows.fuiou.exception.FuiouApiException;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.util.FuiouRequestUtils;
import com.fshows.fuiou.util.LogUtil;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SettlementSignerImpl
implements ISigner {
    private static final Logger log = LoggerFactory.getLogger(SettlementSignerImpl.class);

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        return this.doSign(signParam, apiClientConfig);
    }

    @Override
    public Boolean verifySign(Map<String, String> resMap, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        try {
            String waitSignStr = SettlementSignerImpl.getWaitSignStr(resMap);
            LogUtil.debug(log, "\u3010fuiou-sdk\u3011\u5f85\u9a8c\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", waitSignStr);
            String resSign = resMap.get("sign");
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), SecureUtil.decode((String)apiClientConfig.getFuiouPublicKey()));
            return sign.verify(waitSignStr.getBytes(apiClientConfig.getCharset()), Base64.decode((CharSequence)resSign));
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011fuiou\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> signParam={}", e, verifySignParam);
            throw new FuiouApiException("fuiou\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws FuiouApiException {
        try {
            FuiouBizRequest request = signParam.getRequest();
            Map<String, String> data = FuiouRequestUtils.toMap(request);
            String waitSignStr = SettlementSignerImpl.getWaitSignStr(data);
            LogUtil.debug(log, "\u3010fuiou-sdk\u3011\u5f85\u52a0\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", waitSignStr);
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), null);
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010fuiou-sdk\u3011fuiou\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> signParam={}", e, signParam);
            throw new FuiouApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    public static String getWaitSignStr(Map<String, String> dataMap) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringUtils.equals((CharSequence)key, (CharSequence)"sign") || StringUtils.startsWith((CharSequence)key, (CharSequence)"reserved") || StringUtils.startsWith((CharSequence)key, (CharSequence)"version")) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(StringUtils.defaultString((String)value, (String)""));
        }
        return sb.toString();
    }
}

