/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.steward.handler;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.SimplePropertyPreFilter;
import com.fshows.fuiou.util.SignStrUtil;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.steward.apienum.FuStewardApiDefinitionEnum;
import com.fshows.steward.request.trade.FuStdSubAccountInTransferAsynReq;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FuStewardSignHandler
implements IApiSignHandler {
    private static final Logger log = LoggerFactory.getLogger(FuStewardSignHandler.class);

    public String sign(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws FsApiException {
        String waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            String privateKey = apiClientConfig.getFubeiPrivateKey();
            Map data = apiRequestModel.getParamMap();
            waitSignStr = SignStrUtil.getWaitSignStr(data, requestContext.getNoNeedSignWords());
            if (FuStewardApiDefinitionEnum.SUB_ACCOUNT_IN_TRANSFER_ASYN.equals(requestContext.getIApiDefinition())) {
                FuStdSubAccountInTransferAsynReq req = (FuStdSubAccountInTransferAsynReq)apiRequestModel.getRequest();
                ArrayList ignoreList = CollectionUtil.newArrayList((Object[])new String[]{"transTraceNo", "fee", "feeTraceNo", "feeType", "feeAccount", "srcProtocol", "transferType", "cardNo"});
                SimplePropertyPreFilter filter = new SimplePropertyPreFilter(new String[0]);
                filter.getExcludes().addAll(ignoreList);
                waitSignStr = waitSignStr + "&accountInlist=" + JSONObject.toJSONString(req.getAccountInlist(), (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
            }
            LogUtil.info((Logger)log, (String)"{} >> \u5bcc\u53cb\u52a0\u7b7e >> waitSignStr={}", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), waitSignStr});
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)privateKey), null);
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel, waitSignStr});
            throw new FsApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }

    public Boolean verifySign(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws FsApiException {
        String waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            String publicKey = apiClientConfig.getPayCompanyPublicKey();
            Map data = apiResponseModel.getResponseMap();
            waitSignStr = SignStrUtil.getWaitSignStr(data, requestContext.getNoNeedSignWords());
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), null, SecureUtil.decode((String)publicKey));
            return sign.verify(waitSignStr.getBytes(apiClientConfig.getCharset()), Base64.decode((CharSequence)apiResponseModel.getResponseSign()));
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u54cd\u5e94\u9a8c\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiResponseModel, waitSignStr});
            throw new FsApiException("\u8bf7\u6c42\u9a8c\u7b7e\u5931\u8d25", (Throwable)e);
        }
    }
}

