/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 分账回退接口
 *
 * @author
 * @version FuStdTradeAllocateRefundRes.java, v 0.1 2024-01-02 15:22:42
 */
@Data
public class FuStdTradeAllocateRefundRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555432988488L;


    /**
     * 商户流水号
     * 商户流水号，商户定义的唯一单号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 源分账交易富友批次号
     * 源分账交易富友批次号
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 源支付订单号
     * 富友支付参考流水号
     * (选填)
     */
    @NoSign
    private String srcFasSsn;

    /**
     * 用户编号
     * 用户编号
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 分账回退金额
     * 分账回退金额
     * (必填)
     */
    @NotNull
    private Integer refundAmt;

}