/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 余额分账接口
 *
 * @author
 * @version FuStdBalanceAllocateRes.java, v 0.1 2024-01-02 10:21:58
 */
@Data
public class FuStdBalanceAllocateRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555668712090L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 分账交易富友批次号
     * 
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 分账日期
     * 分账发起日期
     * (必填)
     */
    @NotBlank
    private String allocateDate;

}