/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.trade;

import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 用户委托结算接口
 *
 * @author
 * @version FuStdAccountInDrawoutRes.java, v 0.1 2024-01-02 16:26:53
 */
@Data
public class FuStdAccountInDrawoutRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555132483354L;


    /**
     * 商户流水号
     * 商户流水号
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 富友结算批次号
     * 富友结算批次号
     * (必填)
     */
    @NotBlank
    private String batchNo;

    /**
     * 入账方（用户）编号
     * 入账方（用户）编号
     * (必填)
     */
    @NotBlank
    private String accountIn;

    /**
     * 入账卡号
     * 入账卡号
     * (必填)
     */
    @NotBlank
    private String cleanBankNo;

    /**
     * 发票形式
     * 发票形式
     * (选填)
     */
    private String invoiceType;

}