/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.response.account;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.steward.response.FuStewardBizResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 用户子账户创建接口
 *
 * @author
 * @version FuStdCloneCustomerRes.java, v 0.1 2023-12-28 15:45:17
 */
@Data
public class FuStdCloneCustomerRes extends FuStewardBizResponse {

    private static final long serialVersionUID = -2213838555683134372L;


    /**
     * 交易流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    private String traceNo;

    /**
     * 源用户编号
     * 源分账入账方编号
     * (必填)
     */
    @NotBlank
    private String srcAccountIn;

    /**
     * 用户子账户编号
     * 用户子账户编号
     * (必填)
     */
    @NotBlank
    private String newAccountIn;

    /**
     * 备注
     * 备注
     * (特殊必填)
     */
    private String remark;

}