/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import com.fshows.steward.request.trade.item.FustdSrcFasSsnListReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * 订单批量归集接口
 *
 * @author
 * @version FuStdBatchTradeConcentrateReq.java, v 0.1 2024-01-02 16:31:39
 */
@Data
public class FuStdBatchTradeConcentrateReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555942027540L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 被归集商户号
     * 被归集的商户在富友的唯一代码
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "mchntCdConcentrate长度不能超过30")
    private String mchntCdConcentrate;

    /**
     * 被归集金额
     * 分账金额，单位：分
     * (必填)
     */
    @NotNull
    private Integer amt;

    /**
     * 归集类型
     * 01：已转结订单实时归集
        02：未转结订单预归集
     * (必填)
     */
    @NotBlank
    @Length(max = 2, message = "concentrateType长度不能超过2")
    private String concentrateType;


    /**
     * 订单流水号列表
     */
    private List<FustdSrcFasSsnListReq> srcFasSsnList;

}