/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.steward.request.trade;

import lombok.Data;
import org.hibernate.validator.constraints.Length;
import com.fshows.steward.request.FuStewardBizRequest;
import javax.validation.constraints.NotNull;

import javax.validation.constraints.NotBlank;

/**
 * 转账记账退回接口
 *
 * @author
 * @version FuStdAccountInTransferToMchntRefundReq.java, v 0.1 2024-01-02 15:52:40
 */
@Data
public class FuStdAccountInTransferToMchntRefundReq extends FuStewardBizRequest {

    private static final long serialVersionUID = -2213838555991481813L;


    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 源交易富友批次号
     * 
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "batchNo长度不能超过30")
    private String batchNo;

    /**
     * 用户编号
     * 
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "accountIn长度不能超过30")
    private String accountIn;

    /**
     * 退回金额
     * 
     * (必填)
     */
    @NotNull
    private String amt;

}