/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangyi
 * @version FuStdQueryMchntDrawoutReq.java, v 0.1 2024-11-08 01:31 wangyi
 */
@Data
public class FuStdQueryMchntDrawoutReq extends FuStewardBizRequest {
    private static final long serialVersionUID = -369829379537953918L;

    /**
     * 商户流水号
     * 唯一流水号，商户定义
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 富友批次号
     */
    @NoSign
    private String batchNo;

    /**
     * 源交易商户流水号
     */
    @NoSign
    private String mchntTrace;

    /**
     * 被归集商户号
     * 需加白。传入该字段查询的是被归集商户的记账户明细
     */
    @NoSign
    private String mchntCdConcentrate;

    /**
     * 起始日期
     * 起始日期,YYYYMMdd
     */
    @Length(max = 8, message = "beginDate长度不能超过8")
    @NoSign
    private String beginDate;

    /**
     * 截止日期
     * 截止日期,YYYYMMdd
     */
    @Length(max = 8, message = "endDate长度不能超过8")
    @NoSign
    private String endDate;

    /**
     * 页码
     * (必填)
     */
    @NotNull
    private Integer pageNo;

    /**
     * 分页大小
     * (必填)
     */
    @NotNull
    private Integer pageSize;

    /**
     * 结算账户类型
     * 01 对私，02 对公
     */
    @NoSign
    private String cleanType;
}