/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.steward.request.query;

import com.fshows.steward.annotation.NoSign;
import com.fshows.steward.request.FuStewardBizRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * @author wangqilei
 * @version FuiouElectronicVoucherQueryRequest.java, v 0.1 2024-03-21 11:19 AM wangqilei
 */
@Data
public class FuStdQueryElectronicVoucherReq extends FuStewardBizRequest {
    private static final long serialVersionUID = 6282993327995168535L;
    /**
     * 交易流水号
     */
    @NotBlank
    @Length(max = 30, message = "traceNo长度不能超过30")
    private String traceNo;

    /**
     * 01 分账, 02 用户间转账, 03 委托结算, 04 商户结算, 05 转账记账, 06 充值记账
     */
    @NotBlank
    @Length(max = 2, message = "busiType长度不能超过2")
    private String busiType;

    /**
     * 源交易批次号
     */
    @NoSign
    private String srcBatchNo;

    /**
     * 源交易参考号
     */
    @NoSign
    private String srcFasSsn;
}