/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved
 */
package com.fshows.fuiou.util;

import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import lombok.extern.slf4j.Slf4j;

import java.nio.charset.Charset;

/**
 * @author liubo
 * @version RSAUtil.java, v 0.1 2023-12-27-4:07 下午 liubo
 */
@Slf4j
public class RsaUtils {

    /**
     * 公钥加密
     *
     * @param content   要加密的内容
     * @param publicKey 公钥
     */
    public static String encrypt(String content, String publicKey) {
        try {
            RSA rsa = new RSA(null, publicKey);
            return rsa.encryptBase64(content, KeyType.PublicKey);
        } catch (Exception e) {
            log.error("encrypt >> 富友接口公钥加密异常 >> ", e);
        }
        return null;

    }

    /**
     * 公钥加密
     *
     * @param content   要加密的内容
     * @param publicKey 公钥
     */
    public static String encrypt(String content, String publicKey, Charset charset) {
        try {
            RSA rsa = new RSA(null, publicKey);
            return rsa.encryptBase64(content, charset, KeyType.PublicKey);
        } catch (Exception e) {
            log.error("encrypt >> 富友接口公钥加密异常 >> ", e);
        }
        return null;

    }

    /**
     * 私钥解密
     *
     * @param content    要解密的内容
     * @param privateKey 私钥
     */
    public static String decrypt(String content, String privateKey) {
        try {
            RSA rsa = new RSA(privateKey, null);
            return rsa.decryptStr(content, KeyType.PrivateKey);
        } catch (Exception e) {
            log.error("encrypt >> 富友接口私钥解密异常 >> ", e);
        }
        return null;
    }

    /**
     * 私钥解密
     *
     * @param content    要解密的内容
     * @param privateKey 私钥
     */
    public static String decrypt(String content, String privateKey, Charset charset) {
        try {
            RSA rsa = new RSA(privateKey, null);
            return rsa.decryptStr(content, KeyType.PrivateKey, charset);
        } catch (Exception e) {
            log.error("encrypt >> 富友接口私钥解密异常 >> ", e);
        }
        return null;
    }
}