/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouEquipmentBindResponse;
import com.fshows.fuiou.response.merchant.FuiouEquipmentUnBindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouCallbackAddressRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouEquipmentUnBindRequest extends FuiouBizRequest<FuiouEquipmentUnBindResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555863518977L;

    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 终端序列号
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "tmSerialNo长度不能超过20")
    @JSONField(name = "tm_serial_no")
    private String tmSerialNo;

    /**
     * 0关闭商户，1保留商户开通
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "closeMchnt长度不能超过1")
    @JSONField(name = "close_mchnt")
    private String closeMchnt;
}