/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fuiou.request.merchant;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.fuiou.enums.merchant.FuiouMerchantApiDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.merchant.FuiouEquipmentBindResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * @author
 * @version FuiouCallbackAddressRequest.java, v 0.1 2023-09-16 09:32:01
 */
@Data
public class FuiouEquipmentBindRequest extends FuiouBizRequest<FuiouEquipmentBindResponse, FuiouMerchantApiDefinitionEnum> implements Serializable {

    private static final long serialVersionUID = -2213838555863518977L;

    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 12, message = "traceNo长度不能超过12")
    @JSONField(name = "trace_no")
    private String traceNo;

    /**
     * 商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "mchntCd长度不能超过15")
    @JSONField(name = "mchnt_cd")
    private String mchntCd;

    /**
     * 终端序列号
     * (必填)
     */
    @NotBlank
    @Length(max = 20, message = "tmSerialNo长度不能超过20")
    @JSONField(name = "tm_serial_no")
    private String tmSerialNo;

    /**
     * 终端联系人
     * (必填)
     */
    @Length(max = 15, message = "tmContactPs长度不能超过15")
    @JSONField(name = "tm_contact_ps")
    private String tmContactPs;

    /**
     * 联系人电话
     * (必填)
     */
    @NotBlank
    @Length(max = 60, message = "tmContactPh长度不能超过60")
    @JSONField(name = "tm_contact_ph")
    private String tmContactPh;

    /**
     * 终端布放所在省份
     * (必填)
     */
    @NotBlank
    @Length(max = 3, message = "tmProvCd长度不能超过3")
    @JSONField(name = "tm_prov_cd")
    private String tmProvCd;

    /**
     * 终端布放所在市
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "tmCityCd长度不能超过4")
    @JSONField(name = "tm_city_cd")
    private String tmCityCd;

    /**
     * 终端布放所在区
     * (必填)
     */
    @NotBlank
    @Length(max = 4, message = "tmCountyCd长度不能超过4")
    @JSONField(name = "tm_county_cd")
    private String tmCountyCd;

    /**
     * 终端布放地址
     * (必填)
     */
    @NotBlank
    @Length(max = 160, message = "tmInstArea长度不能超过160")
    @JSONField(name = "tm_inst_area")
    private String tmInstArea;

    /**
     * 是否绑定电话 0未绑定 1已绑定
     * (必填)
     */
    @NotBlank
    @Length(max = 1, message = "tmBindInd长度不能超过1")
    @JSONField(name = "tm_bind_ind")
    private String tmBindInd;

    /**
     * 终端绑定电话号码
     * (选填)
     */
    @Length(max = 8, message = "tmPhoneNo长度不能超过8")
    @JSONField(name = "tm_phone_no")
    private String tmPhoneNo;

    /**
     * 申请备注
     * (选填)
     */
    @Length(max = 128, message = "applyRemark长度不能超过128")
    @JSONField(name = "apply_remark")
    private String applyRemark;
}