/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.request.coupon;

import com.fshows.fuiou.enums.FuiouCouponDefinitionEnum;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.response.coupon.FuiouCouponTransferResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @author mengqf
 * @version FuiouCouponTransferRequest.java, v 0.1 2024-08-16 16:45 mengqf
 */
@Data
public class FuiouCouponTransferRequest extends FuiouBizRequest<FuiouCouponTransferResponse, FuiouCouponDefinitionEnum> implements Serializable {
    private static final long serialVersionUID = -7567053686804566957L;

    /**
     * 唯一流水号
     * (必填)
     */
    @NotBlank
    @Length(max = 30, message = "traceNo不能超过30位")
    private String traceNo;

    /**
     * 营销账号-转出的商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "accountIn不能超过40位")
    private String accountIn;

    /**
     * 入账商户号
     * (必填)
     */
    @NotBlank
    @Length(max = 40, message = "mchntCd不能超过40位")
    private String mchntCd;

    /**
     * 转账金额 单位：分
     * (必填)
     */
    @NotNull
    private Integer txnAmt;

    /**
     * 转账类型
     * 1：营销
     * 2: 核销转账
     * (必填)
     */
    @NotBlank
    private String transType;

    /**
     * 备注
     */
    @Length(max = 128, message = "remark不能超过128位")
    private String remark;
}