/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.fuiou.enums.fgj;

import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.base.FuiouBizRequest;
import com.fshows.fuiou.request.fgj.*;
import com.fshows.fuiou.response.base.FuiouBizResponse;
import com.fshows.fuiou.response.fgj.*;

/**
 * @author zhoujp
 * @version FgjApiDefinitionEnum.java, v 0.1 2024年03月15日14:39:17 zhoujp
 */
public enum FuiouFgjApiDefinitionEnum implements IFuiouApiDefinition {
    MCHNT_ADD(
            "富管家信息登记接口",
            "/fgjmchnt.fuiou?action=mchntAdd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouFgjCreateRequest.class,
            FuiouFgjCreateResponse.class
    ),
    MCHNT_IMG_UPLOAD(
            "富管家图片上传接口",
            "/fgjmchnt.fuiou?action=mchntImgUpload",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouFgjImgUploadRequest.class,
            FuiouFgjImgUploadResponse.class
    ),
    MCHNT_UPDATE(
            "富管家信息更新接口",
            "/fgjmchnt.fuiou?action=mchntUpd",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouFgjUpdateRequest.class,
            FuiouFgjUpdateResponse.class
    ),
    MCHNT_AUDIT(
            "富管家提交审核接口",
            "/fgjmchnt.fuiou?action=mchntAudit",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouFgjAuditRequest.class,
            FuiouFgjAuditResponse.class
    ),
    MCHNT_STATUS_QUERY(
            "富管家开通状态查询接口",
            "/fgjmchnt.fuiou?action=mchntStatusQuery",
            FuiouConstant.MERCHANT_API_VERSION_V1,
            FuiouFgjStatusQueryRequest.class,
            FuiouFgjStatusQueryResponse.class
    ),
    ;
    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    FuiouFgjApiDefinitionEnum(String name, String apiSubURI, String version, Class requestClass, Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public <T extends FuiouBizRequest> Class<T> getRequestClass() {
        return requestClass;
    }

    @Override
    public <T extends FuiouBizResponse> Class<T> getResponseClass() {
        return responseClass;
    }

}