/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fuiou.enums;

import com.fshows.fuiou.client.base.IFuiouApiDefinition;
import com.fshows.fuiou.constant.FuiouConstant;
import com.fshows.fuiou.request.coupon.FuiouCouponTransferCancelRequest;
import com.fshows.fuiou.request.coupon.FuiouCouponTransferQueryRequest;
import com.fshows.fuiou.request.coupon.FuiouCouponTransferRequest;
import com.fshows.fuiou.response.coupon.FuiouCouponTransferCancelResponse;
import com.fshows.fuiou.response.coupon.FuiouCouponTransferQueryResponse;
import com.fshows.fuiou.response.coupon.FuiouCouponTransferResponse;

/**
 * @author mengqf
 * @version FuiouCouponDefinitionEnum.java, v 0.1 2024-08-16 15:09 mengqf
 */
public enum FuiouCouponDefinitionEnum implements IFuiouApiDefinition {

    ACCOUNT_TRANSFER(
            "转账发起",
            "/fatspAccountTransfer.fuiou",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouCouponTransferRequest.class,
            FuiouCouponTransferResponse.class
    ),

    QUERY_TRANSFER_RESULT(
            "转账结果查询",
            "/queryFatspAccountTransfer.fuiou",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouCouponTransferQueryRequest.class,
            FuiouCouponTransferQueryResponse.class
    ),

    ACCOUNT_TRANSFER_CANCEL(
            "转账退回",
                    "/fatspAccountTransferCancel.fuiou",
            FuiouConstant.TRADE_API_VERSION_V1,
            FuiouCouponTransferCancelRequest.class,
            FuiouCouponTransferCancelResponse.class
    ),

    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    FuiouCouponDefinitionEnum(String name,
                           String apiSubURI,
                           String version,
                           Class requestClass,
                           Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}