/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.model;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

import java.util.Map;

/**
 * api响应结果
 *
 * @author liluqing
 * @version ApiResponseModel.java, v 0.1 2023-12-13 16:44
 */
@Data
public class ApiResponseModel {

    /**
     * 响应结果请求头信息
     */
    private Map<String, String> responseHead;

    /**
     * http请求正文
     */
    private String responseBody;

    /**
     * 响应参数map
     */
    private Map<String, Object> responseMap;

    /**
     * 响应参数签名
     */
    private String responseSign;

    /**
     * 请求入参
     */
    private IResponseDefinition response;
}