/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.core.client.tempalte.nest;

import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.handler.ISerializableHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.client.component.serializable.JsonSerializableHandler;
import com.fshows.sdk.core.client.component.signer.RsaSignHandlerImpl;
import com.fshows.sdk.core.client.tempalte.nest.apienum.NestApiDefinitionEnum;
import com.fshows.sdk.core.client.tempalte.nest.request.NestBaseRequest;
import com.fshows.sdk.core.client.tempalte.nest.request.NestBizRequest;
import com.fshows.sdk.core.client.tempalte.nest.response.NestBaseResponse;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.RequestParamUtils;
import java.io.IOException;

public class NestTemplateApiClinet
extends AbstractApiClient<NestBizRequest, NestBaseResponse, NestApiDefinitionEnum> {
    protected IApiSignHandler iApiSignHandler = new RsaSignHandlerImpl();
    protected ISerializableHandler paramSerializable = new JsonSerializableHandler();
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();

    public NestTemplateApiClinet(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
    }

    @Override
    protected ApiRequestModel buildApiRequestModel(NestBizRequest request, DefaultRequestContext context) {
        DefaultClientConfigModel defaultClientConfigModel = context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + context.getIApiDefinition().getApiURI());
        apiRequestModel.setParamMap(RequestParamUtils.toMapObj(request, this.apiClientConfig.isHump(), true));
        apiRequestModel.setRequestSign(this.iApiSignHandler.sign(apiRequestModel, context));
        NestBaseRequest nestBaseRequest = new NestBaseRequest();
        nestBaseRequest.setMchntCd(defaultClientConfigModel.getAppId());
        nestBaseRequest.setSignature(apiRequestModel.getRequestSign());
        nestBaseRequest.setData(request);
        apiRequestModel.setRequest(nestBaseRequest);
        String requestBody = this.paramSerializable.serializeObject(apiRequestModel, context);
        apiRequestModel.setRequestBody(requestBody);
        return apiRequestModel;
    }

    @Override
    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientCode("fuiou-sdk");
        clientInfoModel.setClientCode("\u5bcc\u53cb\u5206\u8d26");
        return clientInfoModel;
    }

    @Override
    protected NestBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        return null;
    }

    @Override
    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    @Override
    public NestBaseResponse execute(NestBizRequest request, NestApiDefinitionEnum apiDefinition) throws FsApiException {
        return (NestBaseResponse)super.doExecute(request, apiDefinition);
    }

    @Override
    public NestBaseResponse execute(NestBizRequest request, NestApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return (NestBaseResponse)super.doExecute(request, apiDefinition, configModel);
    }
}

