/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.core.client.component.signer;

import com.fshows.sdk.core.client.base.handler.IApiSignHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.SignerUtil;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Md5SignHandlerImpl
implements IApiSignHandler {
    private static final Logger log = LoggerFactory.getLogger(Md5SignHandlerImpl.class);

    @Override
    public String sign(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws FsApiException {
        String waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            Map<String, Object> data = apiRequestModel.getParamMap();
            waitSignStr = SignerUtil.getWaitSignStr(data, apiClientConfig.getMd5SignKey());
            LogUtil.info(log, "{} >> \u5f85\u52a0\u7b7e\u5b57\u7b26\u4e32 >> waitSignStr={}", requestContext.getClientInfoModel().getClientDesc(), waitSignStr);
            String md5Hex = DigestUtils.md5Hex((byte[])waitSignStr.getBytes(apiClientConfig.getCharset()));
            return md5Hex.toLowerCase();
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", e, requestContext.getClientInfoModel().getClientDesc(), apiRequestModel, waitSignStr);
            throw new FsApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }

    @Override
    public Boolean verifySign(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws FsApiException {
        String waitSignStr = null;
        try {
            DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();
            String resSign = apiResponseModel.getResponseSign();
            waitSignStr = SignerUtil.getWaitSignStr(apiResponseModel.getResponseMap(), apiClientConfig.getMd5SignKey());
            String md5Hex = DigestUtils.md5Hex((byte[])waitSignStr.getBytes(apiClientConfig.getCharset())).toLowerCase();
            return resSign.equalsIgnoreCase(md5Hex);
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> apiRequestModel={}, waitSignStr={}", e, apiRequestModel, waitSignStr);
            throw new FsApiException("\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }
}

