/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.core.client.base;

import cn.hutool.core.bean.BeanUtil;
import com.fshows.sdk.core.client.base.IApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import com.fshows.sdk.core.util.ValidateUtil;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApiClient<REQ extends IRequestDefinition, RES extends IResponseDefinition, API extends IApiDefinition>
implements IApiClient<REQ, RES, API> {
    private static final Logger log = LoggerFactory.getLogger(AbstractApiClient.class);
    protected DefaultClientConfigModel apiClientConfig;

    public AbstractApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        ValidateUtil.validateWithThrow(apiClientConfig, new Class[0]);
        this.apiClientConfig = apiClientConfig;
    }

    protected RES doExecute(REQ request, API iApiDefinition) throws FsApiException {
        return this.doExecute(request, iApiDefinition, null);
    }

    protected RES doExecute(REQ request, API iApiDefinition, DefaultClientConfigModel merchantConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info(log, "{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", this.getClientInfo().getClientDesc(), iApiDefinition, request);
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, merchantConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), apiRequestModel.getRequestForm());
            LogUtil.info(log, "{} >> \u8bf7\u6c42\u7ed3\u675f >> url={}, method={}, request={}, response={}, cost={}ms", requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), System.currentTimeMillis() - beginTime);
            return this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        catch (FsApiException e) {
            LogUtil.error(log, "{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", e, requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "{} >> \u8bf7\u6c42\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", e, requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel);
            throw new FsApiException(e.getMessage(), e);
        }
    }

    protected DefaultRequestContext buildRequestContext(API tradeApiDefinitionEnum, REQ request, DefaultClientConfigModel merchantConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition((IApiDefinition)tradeApiDefinitionEnum);
        DefaultClientConfigModel clientConfig = this.apiClientConfig;
        DefaultClientConfigModel config = (DefaultClientConfigModel)BeanUtil.copyProperties((Object)clientConfig, DefaultClientConfigModel.class);
        merchantConfig.setExtendParam(new HashMap<String, String>(clientConfig.getExtendParam()));
        config.setAppId(StringUtils.isEmpty((CharSequence)merchantConfig.getAppId()) ? clientConfig.getAppId() : merchantConfig.getAppId());
        config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)merchantConfig.getFubeiPrivateKey()) ? clientConfig.getFubeiPrivateKey() : merchantConfig.getFubeiPrivateKey());
        config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)merchantConfig.getPayCompanyPublicKey()) ? clientConfig.getPayCompanyPublicKey() : merchantConfig.getPayCompanyPublicKey());
        context.setApiClientConfig(config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected abstract ApiRequestModel buildApiRequestModel(REQ var1, DefaultRequestContext var2);

    protected abstract ClientInfoModel getClientInfo();

    protected void checkParam(REQ bizRequest, DefaultRequestContext defaultRequestContext) throws FsApiException {
        ValidateUtil.notNull(bizRequest, "request\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtil.notNull(defaultRequestContext.getIApiDefinition(), "request\u8bf7\u6c42\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a");
        boolean checkRequestClass = StringUtils.equals((CharSequence)bizRequest.getClass().getCanonicalName(), (CharSequence)defaultRequestContext.getIApiDefinition().getRequestClass().getCanonicalName());
        if (!checkRequestClass) {
            throw new FsApiException("\u8bf7\u6c42\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        if (this.apiClientConfig.isCheckParam()) {
            ValidateUtil.validateWithThrow(bizRequest, new Class[0]);
        }
    }

    protected abstract RES buildApiResponse(ApiResponseModel var1, ApiRequestModel var2, DefaultRequestContext var3);

    protected abstract ApiResponseModel httpRequest(ApiRequestModel var1, DefaultRequestContext var2) throws IOException;

    public void setApiClientConfig(DefaultClientConfigModel apiClientConfig) {
        this.apiClientConfig = apiClientConfig;
    }
}

