/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.sdk.core.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.StrUtil;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;

/**
 *
 * @author liluqing
 * @version SignerUtil.java, v 0.1 2023-12-11 20:35
 */
public class SignerUtil {

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, Object> dataMap, String signKey) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, null);
        waitSignStr.append("&key=").append(signKey);
        return waitSignStr.toString();
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, Object> dataMap) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, null);
        return waitSignStr.toString();
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    public static String getWaitSignStr(Map<String, Object> dataMap, String[] ignoreList) {
        StringBuilder waitSignStr = generateWaitSignStr(dataMap, ignoreList);
        return waitSignStr.toString();
    }

    /**
     * 获取待加签字符串，格式：addn_inf=&curr_type=&goods_des=卡盟测试&goods_detail=asasda&goods_tag=&ins_cd=08A9999999&
     *
     * @return
     */
    private static StringBuilder generateWaitSignStr(Map<String, Object> dataMap, String[] ignoreList) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            String value = "";
            if (entry.getValue() != null) {
                value = String.valueOf(entry.getValue());
            }
            if (StringUtils.equals(key, "sign")
                    || StringUtils.startsWith(key, "reserved")
                    || ArrayUtil.contains(ignoreList, key)) {
                continue;
            }
            if (StrUtil.isBlank(value)) {
                continue;
            }
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(key).append("=").append(value);
        }
        return sb;
    }
}