/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.sdk.core.util;

import cn.hutool.core.date.DatePattern;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;

import java.util.Date;
import java.util.UUID;

/**
 * 请求ID工具类
 *
 * @author liluqing
 * @version ReqIdUtil.java, v 0.1 2022-03-08 9:35
 */
public class ReqIdUtil {

    public static String getId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    /**
     * 生成测试用的订单号
     *
     * @return
     */
    public static String getTestOrderSn() {
        return DateUtil.format(new Date(), DatePattern.PURE_DATETIME_MS_PATTERN) + RandomUtil.randomInt(3);
    }

    public static String getOrderNo() {
        return DateUtil.format(new Date(), DatePattern.PURE_DATETIME_PATTERN) + RandomUtil.randomNumbers(8);
    }

    public static String getTradeNo() {
        return getId().substring(0, 12);
    }
}