/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.model;

import com.fshows.sdk.core.constant.CommonConstant;
import com.fshows.sdk.core.enums.base.SignTypeEnum;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.HashMap;
import java.util.Map;

/**
 * 客户端配置信息model
 *
 * @author liluqing
 * @version ClientMetaInfoModel.java, v 0.1 2022-03-01 20:37
 */
@Data
public class DefaultClientConfigModel {

    /**
     * 接口网关根URL
     */
    @NotBlank(message = "api客户端网关根地址不能为空")
    protected String apiParentURL;

    /**
     * appid
     */
    protected String appId;

    /**
     * 用于加签的付呗私钥
     */
    protected String fubeiPrivateKey;

    /**
     * 用于验签的支付公司公钥
     */
    protected String payCompanyPublicKey;

    /**
     * md5加签KEY
     */
    protected String md5SignKey;

    /**
     * 加签算法类型
     */
    protected SignTypeEnum signTypeEnum = SignTypeEnum.MD5WithRSA;

    /**
     * 是否对响应结果进行验签
     */
    protected boolean vrifySignResponse = true;

    /**
     * 是否对参数进行前置校验
     */
    protected boolean checkParam = true;

    /**
     * http连接超时时间
     */
    protected int connectionTimeout = CommonConstant.DEFAULT_CONNECTION_TIMEOUT;

    /**
     * http response读取超时时间
     */
    protected int readTimeout = CommonConstant.DEFAULT_READ_TIMEOUT;

    /**
     * 默认编码格式，默认为utf-8
     */
    protected String charset = CommonConstant.GBK;

    /**
     * 是否驼峰（加签使用）
     */
    protected boolean isHump = false;

    /**
     * 扩展参数
     */
    protected Map<String, String> extendParam = new HashMap<>();
}