/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.sdk.core.client.base.definition;

/**
 * API资源定义
 * <p>
 * 目前API资源采用enum方式定义
 *
 * @author liluqing
 * @version ISwiftApiDefinition.java, v 0.1 2022-03-01 20:24
 */
public interface IApiDefinition {

    /**
     * 资源名称
     * 这类存在两种情况,
     * 路径：接口的URL是 “https://s2.lakala.com/api/v3/labs/trans/preorder”,则getApiURI则是域名后的部分内容“/api/v3/labs/trans/preorder”
     * 资源名：
     *
     */
    String getApiURI();

    /**
     * 获取api版本
     *
     * @return
     */
    String getVersion();

    /**
     * 获取requestClass
     *
     * @return
     */
    <T extends IRequestDefinition>  Class<T> getRequestClass();

    /**
     * 获取responseClass
     *
     * @return
     */
    <T extends IResponseDefinition> Class<T> getResponseClass();
}