/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.id.service.config;

import com.fshow.id.service.expection.IdProduceClientException;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.JedisPool;

public class RedisIdProduceConfig {
    private static final int DEFAULT_SECOND_EXPIRE = 15;
    private static final int MAX_SECOND_EXPIRE = 60;
    private static final int DEFAULT_SHARDING_LENGTH = 4;
    private static final int MAX_SHARDING_LENGTH = 10;
    private static final int DEFAULT_OBLIGATE_LENGTH = 4;
    private static final int MAX_OBLIGATE_LENGTH = 10;
    private static final int DEFAULT_BUSINESS_LENGTH = 2;
    private static final int MAX_BUSINESS_LENGTH = 10;
    private static final int DEFAULT_MS_SEQUENCE_LENGTH = 4;
    private static final int MAX_MS_SEQUENCE_LENGTH = 6;
    private static final int MIN_MS_SEQUENCE_LENGTH = 2;
    private String cacheKeyBase;
    private JedisPool jedisPool;
    private Integer secondExpire;
    private Integer shardingLength;
    private Integer obligateLength;
    private Integer businessLength;
    private Integer msSequenceLength;
    private Integer msSequenceLocalSize;

    public RedisIdProduceConfig build() {
        this.checkMustParams();
        this.checkParamsRange();
        return this;
    }

    public String getCacheKeyBase() {
        return this.cacheKeyBase;
    }

    public void setCacheKeyBase(String cacheKeyBase) {
        this.cacheKeyBase = cacheKeyBase;
    }

    public JedisPool getJedisPool() {
        return this.jedisPool;
    }

    public void setJedisPool(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    public Integer getSecondExpire() {
        return this.secondExpire;
    }

    public void setSecondExpire(Integer secondExpire) {
        this.secondExpire = secondExpire;
    }

    public Integer getShardingLength() {
        return this.shardingLength;
    }

    public void setShardingLength(Integer shardingLength) {
        this.shardingLength = shardingLength;
    }

    public Integer getObligateLength() {
        return this.obligateLength;
    }

    public void setObligateLength(Integer obligateLength) {
        this.obligateLength = obligateLength;
    }

    public Integer getBusinessLength() {
        return this.businessLength;
    }

    public void setBusinessLength(Integer businessLength) {
        this.businessLength = businessLength;
    }

    public Integer getMsSequenceLength() {
        return this.msSequenceLength;
    }

    public void setMsSequenceLength(Integer msSequenceLength) {
        this.msSequenceLength = msSequenceLength;
    }

    public Integer getMsSequenceLocalSize() {
        return this.msSequenceLocalSize;
    }

    public void setMsSequenceLocalSize(Integer msSequenceLocalSize) {
        this.msSequenceLocalSize = msSequenceLocalSize;
    }

    private void checkMustParams() {
        if (StringUtils.isBlank((CharSequence)this.cacheKeyBase)) {
            throw IdProduceClientException.CLIENT_INIT_PARAMS_ERROR;
        }
        if (this.jedisPool == null) {
            throw IdProduceClientException.CLIENT_INIT_JEDIS_ERROR;
        }
        if (this.jedisPool.isClosed()) {
            throw IdProduceClientException.CLIENT_INIT_JEDIS_ERROR;
        }
    }

    private void checkParamsRange() {
        if (null == this.secondExpire) {
            this.secondExpire = 15;
        } else if (this.secondExpire <= 0 || this.secondExpire > 60) {
            throw IdProduceClientException.SECOND_EXPIRE_OUT_OF_MAX;
        }
        if (null == this.shardingLength) {
            this.shardingLength = 4;
        } else if (this.shardingLength < 0 || this.shardingLength > 10) {
            throw IdProduceClientException.CLIENT_INIT_PARAMS_ERROR;
        }
        if (null == this.obligateLength) {
            this.obligateLength = 4;
        } else if (this.obligateLength < 0 || this.obligateLength > 10) {
            throw IdProduceClientException.CLIENT_INIT_PARAMS_ERROR;
        }
        if (null == this.businessLength) {
            this.businessLength = 2;
        } else if (this.businessLength < 0 || this.businessLength > 10) {
            throw IdProduceClientException.CLIENT_INIT_PARAMS_ERROR;
        }
        if (null == this.msSequenceLength) {
            this.msSequenceLength = 4;
        } else if (this.msSequenceLength <= 2 || this.msSequenceLength > 6) {
            throw IdProduceClientException.CLIENT_INIT_PARAMS_ERROR;
        }
        int base = 1;
        for (int i = 0; i < this.msSequenceLength; ++i) {
            base *= 10;
        }
        int maxSequence = base - 1;
        if (null == this.msSequenceLocalSize) {
            this.msSequenceLocalSize = base / 20;
        } else if (this.msSequenceLocalSize <= 0 || this.msSequenceLocalSize > maxSequence) {
            throw IdProduceClientException.CLIENT_INIT_PARAMS_ERROR;
        }
    }
}

