/*
 * Decompiled with CFR 0.152.
 */
package com.fshow.id.service.client;

import com.fshow.id.service.client.IdProduceClient;
import com.fshow.id.service.client.RedisIdProduceClientBase;
import com.fshow.id.service.config.RedisIdProduceConfig;
import com.fshow.id.service.pojo.TimeSeqResult;
import com.fshows.fsframework.core.utils.SystemClock;

public class RedisIdProduceClient
extends RedisIdProduceClientBase
implements IdProduceClient {
    public RedisIdProduceClient(RedisIdProduceConfig config) {
        super(config);
    }

    @Override
    public String getId(String shardingCode, String obligateCode, String businessCode) {
        String finalShardingCode = this.getShardingCode(shardingCode);
        String finalObligateCode = this.getObligateCode(obligateCode);
        String finalBusinessCode = this.getBusinessCode(businessCode);
        long currentTime = SystemClock.millisClock().now();
        TimeSeqResult timeSeqResult = new TimeSeqResult();
        timeSeqResult.setTimeStamp(currentTime);
        this.getSequenceByCache(timeSeqResult);
        String finalCurrentTime = String.valueOf(timeSeqResult.getTimeStamp());
        return this.buildId(finalCurrentTime, finalShardingCode, finalObligateCode, finalBusinessCode, timeSeqResult.getSequence());
    }

    @Override
    public String getId(String businessCode) {
        return this.getId(null, null, businessCode);
    }

    private String buildId(String timeStamp, String shardingCode, String obligateCode, String businessCode, int sequence) {
        StringBuilder builder = new StringBuilder();
        builder.append(timeStamp);
        builder.append(shardingCode);
        builder.append(obligateCode);
        builder.append(businessCode);
        builder.append(this.supplyRender(sequence));
        return builder.toString();
    }
}

