///**
// * fshows.com
// * Copyright (C) 2018 All Rights Reserved.
// */
//package com.fshow.id.service.utils;
//
//import java.util.concurrent.Executors;
//import java.util.concurrent.ScheduledExecutorService;
//import java.util.concurrent.TimeUnit;
//import java.util.concurrent.atomic.AtomicLong;
//
///**
// * @author shijw
// * @version SystemClock.java
// * 系统时钟
// */
//public class SystemClock {
//    private static final SystemClock MILLIS_CLOCK = new SystemClock(1);
//    private final long precision;
//    private final AtomicLong now;
//
//    private SystemClock(long precision) {
//        this.precision = precision;
//        now = new AtomicLong(System.currentTimeMillis());
//        scheduleClockUpdating();
//    }
//
//    public static SystemClock millisClock() {
//        return MILLIS_CLOCK;
//    }
//
//    private void scheduleClockUpdating() {
//        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(runnable -> {
//            Thread thread = new Thread(runnable, "system.clock");
//            thread.setDaemon(true);
//            return thread;
//        });
//        scheduler.scheduleAtFixedRate(() -> now.set(System.currentTimeMillis()), precision, precision, TimeUnit.MILLISECONDS);
//    }
//
//    public long now() {
//        return now.get();
//    }
//}
