/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.web.service;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.fshows.fsframework.common.exception.CommonException;
import com.fshows.fsframework.core.BaseParam;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.web.bean.ApplicationContextHelper;
import com.fshows.fsframework.web.domain.ApiContainer;
import com.fshows.fsframework.web.domain.ApiDescriptor;
import com.fshows.fsframework.web.exception.ApiInvokeException;
import com.fshows.fsframework.web.service.ApiInvoker;
import com.fshows.fsframework.web.service.IApiClient;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public abstract class SentinelLimitApiInvokeService {
    private static final Logger log = LoggerFactory.getLogger(SentinelLimitApiInvokeService.class);
    @Autowired
    protected IApiClient apiClient;
    @Autowired
    protected ApiContainer apiContainer;
    @Value(value="${rate.limit.switch:true}")
    private String rateLimitSwitch;

    public <P extends BaseParam, R> R invoke(String appId, String sign, String apiMethodName, Map<String, Object> params, String content) throws Throwable {
        ApiDescriptor apiDescriptor = (ApiDescriptor)this.apiContainer.get(apiMethodName);
        if (null == apiDescriptor) {
            throw ApiInvokeException.API_NOT_EXIST;
        }
        String beanName = apiDescriptor.getBeanName();
        Object bean = ApplicationContextHelper.getBean(beanName);
        if (null == bean) {
            throw ApiInvokeException.API_NOT_EXIST;
        }
        Boolean hasPermission = this.checkPermission(appId, apiMethodName);
        if (!hasPermission.booleanValue()) {
            throw ApiInvokeException.DO_NOT_HAS_PERMISSION;
        }
        Boolean checkSign = this.checkSign(params, appId);
        if (!checkSign.booleanValue()) {
            throw ApiInvokeException.API_INVALID_SIGIN;
        }
        return (R)this.doInvoke(appId, apiMethodName, content, (method, param) -> apiDescriptor.getMethod().invoke(bean, param));
    }

    protected <P extends BaseParam, R> R doInvoke(String appId, String method, String paramJsonStr, ApiInvoker<P, R> invoker) throws Throwable {
        boolean rateLimit = StringUtils.equalsIgnoreCase((CharSequence)this.rateLimitSwitch, (CharSequence)"true");
        Object[] hotParam = null;
        Entry entry = null;
        try {
            if (rateLimit) {
                hotParam = this.getHotParam(appId, method, paramJsonStr);
                if (hotParam == null) {
                    hotParam = new Object[]{};
                }
                entry = SphU.entry((String)method, (EntryType)EntryType.IN, (int)1, (Object[])hotParam);
            }
            R r = this.apiClient.invoke(method, paramJsonStr, invoker);
            return r;
        }
        catch (BlockException ex) {
            LogUtil.warn((Logger)log, (String)"\u7f51\u5173\u8bf7\u6c42\u9650\u6d41 >> method={}, hotParam={}", (Throwable)ex, (Object[])new Object[]{method, hotParam});
            throw CommonException.RATE_LIMIT_EXCEPTION;
        }
        finally {
            if (rateLimit && entry != null) {
                entry.exit(1, hotParam);
            }
        }
    }

    protected abstract Object[] getHotParam(String var1, String var2, String var3);

    protected abstract boolean checkPermission(String var1, String var2);

    protected abstract boolean checkSign(Map<String, Object> var1, String var2);
}

