/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.loadbalance;

import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.utils.NetUtils;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.RpcContext;
import com.alibaba.dubbo.rpc.cluster.loadbalance.RandomLoadBalance;
import com.fshows.fsframework.core.utils.LogUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableLoadBalance
extends RandomLoadBalance {
    private static final Logger log = LoggerFactory.getLogger(StableLoadBalance.class);
    public static final String NAME = "stable";
    public static final String SOURCE_KEY = "SOURCE_IP_KEY";
    public static final String STABLE_IP_KEY = "STABLE_IP_KEY";

    public <T> Invoker<T> select(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        return this.doSelect(invokers, url, invocation);
    }

    protected <T> Invoker<T> doSelect(List<Invoker<T>> invokers, URL url, Invocation invocation) {
        String stableIp;
        String sourceIpByContext = RpcContext.getContext().getAttachment(SOURCE_KEY);
        LogUtil.info((Logger)log, (String)"doSelect >> \u5f00\u59cb >> invokers = {}, url = {}, invocation = {}, sourceIp = {}", (Object[])new Object[]{invokers, url, invocation, sourceIpByContext});
        if (StrUtil.isBlank((CharSequence)sourceIpByContext)) {
            sourceIpByContext = NetUtils.getLocalHost();
            RpcContext.getContext().setAttachment(SOURCE_KEY, sourceIpByContext);
            LogUtil.info((Logger)log, (String)"doSelect >> \u6ca1\u6709\u4e0a\u4e0b\u6587\u6e90 ip\uff0c\u521d\u59cb\u5316 ip >> invokers = {}, url = {}, invocation = {}, ip = {}", (Object[])new Object[]{invokers, url, invocation, sourceIpByContext});
        }
        String filterIp = sourceIpByContext;
        List filterIpInvokers = invokers.stream().filter(it -> it.getUrl().getIp().equals(filterIp)).collect(Collectors.toList());
        if (filterIpInvokers.isEmpty() && StrUtil.isNotBlank((CharSequence)(stableIp = System.getProperty(STABLE_IP_KEY)))) {
            filterIpInvokers = invokers.stream().filter(it -> !it.getUrl().getIp().equals(stableIp)).collect(Collectors.toList());
        }
        if (!filterIpInvokers.isEmpty()) {
            invokers = filterIpInvokers;
        }
        LogUtil.info((Logger)log, (String)"doSelect \u7ed3\u675f >>  >> invokers = {}, url = {}, invocation = {}, filterIpInvokers = {}", (Object[])new Object[]{invokers, url, invocation, filterIpInvokers});
        return super.doSelect(invokers, url, invocation);
    }
}

