/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package
        com.fshows.fsframework.extend.aliyun.oss;

import com.fshows.fsframework.extend.util.ConfigUtil;
import lombok.Data;
import lombok.Setter;
import org.springframework.context.ApplicationContext;

import javax.validation.constraints.NotNull;

/**
 *
 * @author liluqing
 * @version FsOssConfig.java, v 0.1 2025-05-19 16:54
 */
@Setter
public class FsOssConfig {

    /**
     * spring上下文
     */
    private ApplicationContext applicationContext;

    public FsOssConfig() {
    }

    /**
     * 【必填参数】AES密码
     */
    @NotNull
    private String aesPassword = "${fs.aliyun.key.aes.encry.password}";

    /**
     * 【必填参数】加密的aksk
     */
    @NotNull
    private String encryAccessKey = "${fs.aliyun.oss.access.key}";
    @NotNull
    private String encrySecretKey = "${fs.aliyun.oss.secret.key}";

    /**
     * 【可选】是否使用外网客户端
     */
    private String ossOutClientFlag = "${fs.aliyun.oss.out.client.flag:false}";

    /**
     * 【可选】oss 外网地址
     */
    private String ossEndPointOut = "${fs.aliyun.oss.out.url:https://oss-cn-hangzhou.aliyuncs.com}";

    /**
     * 【可选】oss 内网地址
     */
    private String ossEndPointInner = "${fs.aliyun.oss.inner.url:https://oss-cn-hangzhou-internal.aliyuncs.com}";

    /**
     * 【可选】外网链接过期时间
     */
    private String urlExpireTime = "${fs.aliyun.oss.url.expire.time:3600}";

    /**
     * 【可选】关闭旧客户端的延迟时间，单位秒
     */
    private String closeDelayTime = "${fs.aliyun.oss.close.delay.time:30}";

    /**
     * Getter method for property <tt>ossOutClientFlag</tt>.
     *
     * @return property value of ossOutClientFlag
     */
    public Boolean getOssOutClientFlag() {
        return ConfigUtil.getProperty(ossOutClientFlag, Boolean.class, applicationContext);
    }

    /**
     * Getter method for property <tt>ossEndPointOut</tt>.
     *
     * @return property value of ossEndPointOut
     */
    public String getOssEndPointOut() {
        return ConfigUtil.getProperty(ossEndPointOut, applicationContext);
    }

    /**
     * Getter method for property <tt>ossEndPointInner</tt>.
     *
     * @return property value of ossEndPointInner
     */
    public String getOssEndPointInner() {
        return ConfigUtil.getProperty(ossEndPointInner, applicationContext);
    }

    /**
     * Getter method for property <tt>urlExpireTime</tt>.
     *
     * @return property value of urlExpireTime
     */
    public Integer getUrlExpireTime() {
        return ConfigUtil.getProperty(urlExpireTime, Integer.class, applicationContext);
    }

    /**
     * Getter method for property <tt>closeDelayTime</tt>.
     *
     * @return property value of closeDelayTime
     */
    public Integer getCloseDelayTime() {
        return ConfigUtil.getProperty(closeDelayTime, Integer.class, applicationContext);
    }

    /**
     * Getter method for property <tt>aesPassword</tt>.
     *
     * @return property value of aesPassword
     */
    public String getAesPassword() {
        return ConfigUtil.getProperty(aesPassword, applicationContext);
    }

    /**
     * Getter method for property <tt>encryAccessKey</tt>.
     *
     * @return property value of encryAccessKey
     */
    public String getEncryAccessKey() {
        return ConfigUtil.getProperty(encryAccessKey, applicationContext);
    }

    /**
     * Getter method for property <tt>encrySecretKey</tt>.
     *
     * @return property value of encrySecretKey
     */
    public String getApolloKeyForEncrySecretKey() {
        return ConfigUtil.getDynamicKey(encrySecretKey);
    }

    /**
     * Getter method for property <tt>encryAccessKey</tt>.
     *
     * @return property value of encryAccessKey
     */
    public String getApolloKeyForEncryAccessKey() {
        return ConfigUtil.getDynamicKey(encryAccessKey);
    }

    /**
     * Getter method for property <tt>encrySecretKey</tt>.
     *
     * @return property value of encrySecretKey
     */
    public String getEncrySecretKey() {
        return ConfigUtil.getProperty(encrySecretKey, applicationContext);
    }

    /**
     * oss客户端是否在ak变更后动态更新
     *
     * @return
     */
    public Boolean getOssClientDynamicUpdate() {
        return ConfigUtil.isDynamicProperty(encryAccessKey) && ConfigUtil.isDynamicProperty(encrySecretKey);
    }
}