/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.qos;

import com.alibaba.dubbo.config.spring.ServiceBean;
import com.alibaba.dubbo.qos.command.BaseCommand;
import com.alibaba.dubbo.qos.command.CommandContext;
import com.alibaba.dubbo.qos.command.annotation.Cmd;
import com.alibaba.dubbo.qos.command.impl.Offline;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

@Cmd(name="offline", summary="offline dubbo", example={"offline dubbo", "offline xx.xx.xxx.service"})
public class FsOffline
extends Offline
implements BaseCommand {
    private static final String ALL_SERVICE = ".*";
    private static final String OK = "OK";

    public String execute(CommandContext commandContext, String[] args) {
        String servicePattern = ALL_SERVICE;
        if (args != null && args.length > 0) {
            servicePattern = args[0];
        }
        String resultStr = super.execute(commandContext, args);
        if (!StringUtils.equals((CharSequence)servicePattern, (CharSequence)ALL_SERVICE) || !StringUtils.equals((CharSequence)resultStr, (CharSequence)OK)) {
            return resultStr;
        }
        this.closeMqConsumer();
        return OK;
    }

    private void closeMqConsumer() {
        ApplicationContext applicationContext = ServiceBean.getSpringContext();
        if (applicationContext == null) {
            return;
        }
        Map map = applicationContext.getBeansOfType(ConsumerBean.class);
        if (map == null || map.size() == 0) {
            return;
        }
        for (ConsumerBean c : map.values()) {
            if (c == null || c.isClosed()) continue;
            c.shutdown();
        }
    }
}

