/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.dubbo.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.fastjson.JSONObject;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.dubbo.model.DubboMethodMonitorConfigConvertModel;
import com.fshows.fsframework.extend.dubbo.model.DubboMethodMonitorConfigModel;
import com.fshows.fsframework.extend.util.SpringContextUtil;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

@Activate(group={"provider"}, order=-9999)
public class GlobalDubboMethodMonitor
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(GlobalDubboMethodMonitor.class);
    private static final String DUBBO_METHOD_MONITOR_SWITCH = "dubbo.method.monitor.switch";
    private static final String DUBBO_METHOD_MONITOR_CONFIG = "dubbo.method.monitor.config";
    private static volatile DubboMethodMonitorConfigConvertModel configModel = null;

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        Environment environment = SpringContextUtil.getEnvironment();
        if (environment != null) {
            if ("1".equals(environment.getProperty(DUBBO_METHOD_MONITOR_SWITCH))) {
                ConcurrentMap<String, List<DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel>> methodMonitorConfigMap;
                DubboMethodMonitorConfigConvertModel methodMonitorConfigModel = null;
                try {
                    methodMonitorConfigModel = this.getMethodMonitorConfigModel();
                }
                catch (Throwable e) {
                    LogUtil.error((Logger)log, (String)"record bad-facade info get monitor config error >> dubbo\u6162\u8c03\u7528\u76d1\u63a7\uff0c\u52a0\u8f7d\u914d\u7f6e\u53c2\u6570\u5f02\u5e38", (Throwable)e);
                }
                if (methodMonitorConfigModel != null && CollUtil.isNotEmpty(methodMonitorConfigMap = methodMonitorConfigModel.getMethodMonitorConfigMap())) {
                    String methodName = invoker.getUrl().getPath() + "." + invocation.getMethodName();
                    List methodMonitorLevelConfigModels = (List)methodMonitorConfigMap.get(methodName);
                    if (CollUtil.isEmpty((Collection)methodMonitorLevelConfigModels)) {
                        methodMonitorLevelConfigModels = (List)methodMonitorConfigMap.get("default");
                    }
                    if (CollUtil.isNotEmpty((Collection)methodMonitorLevelConfigModels)) {
                        long rpcStartTime = SystemClock.millisClock().now();
                        Result result = invoker.invoke(invocation);
                        long rpcEndTime = SystemClock.millisClock().now();
                        long timeConsuming = rpcEndTime - rpcStartTime;
                        Object[] arguments = invocation.getArguments();
                        for (DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel methodMonitorLevelConfigModel : methodMonitorLevelConfigModels) {
                            if (timeConsuming <= (long)methodMonitorLevelConfigModel.getLowerThreshold().intValue()) continue;
                            LogUtil.warn((Logger)log, (String)"record bad-facade info >> timeConsumingLevel={}, methodName={}, arguments={}, time={}ms", (Object[])new Object[]{methodMonitorLevelConfigModel.getLevel(), methodName, arguments, timeConsuming});
                            break;
                        }
                        return result;
                    }
                }
            } else {
                configModel = null;
            }
        }
        return invoker.invoke(invocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DubboMethodMonitorConfigConvertModel getMethodMonitorConfigModel() {
        if (configModel == null) {
            GlobalDubboMethodMonitor globalDubboMethodMonitor = this;
            synchronized (globalDubboMethodMonitor) {
                if (configModel == null) {
                    Environment environment = SpringContextUtil.getEnvironment();
                    if (environment == null) {
                        return null;
                    }
                    DubboMethodMonitorConfigConvertModel methodMonitorConfigConvertModel = new DubboMethodMonitorConfigConvertModel();
                    String methodMonitorConfigStr = environment.getProperty(DUBBO_METHOD_MONITOR_CONFIG);
                    if (StrUtil.isNotBlank((CharSequence)methodMonitorConfigStr)) {
                        List<DubboMethodMonitorConfigModel.MethodMonitorPointConfigModel> methodMonitorPointConfigList;
                        ConcurrentMap methodMonitorConfigMap = Maps.newConcurrentMap();
                        DubboMethodMonitorConfigModel config = (DubboMethodMonitorConfigModel)JSONObject.parseObject((String)methodMonitorConfigStr, DubboMethodMonitorConfigModel.class);
                        if (config != null && CollUtil.isNotEmpty(methodMonitorPointConfigList = config.getMethodMonitorPointConfigList())) {
                            for (DubboMethodMonitorConfigModel.MethodMonitorPointConfigModel methodMonitorPointConfigModel : methodMonitorPointConfigList) {
                                List methodMonitorLevelConfig = methodMonitorPointConfigModel.getMethodMonitorLevelConfigList().stream().sorted(Comparator.comparingInt(DubboMethodMonitorConfigModel.MethodMonitorLevelConfigModel::getLowerThreshold).reversed()).collect(Collectors.toList());
                                for (String singleMethodName : methodMonitorPointConfigModel.getMethodName().split(",")) {
                                    methodMonitorConfigMap.put(singleMethodName, methodMonitorLevelConfig);
                                }
                            }
                        }
                        methodMonitorConfigConvertModel.setMethodMonitorConfigMap(methodMonitorConfigMap);
                    }
                    configModel = methodMonitorConfigConvertModel;
                }
            }
        }
        return configModel;
    }
}

