/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.oss;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.symmetric.AES;
import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.comm.Protocol;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.ctrip.framework.apollo.enums.PropertyChangeType;
import com.ctrip.framework.apollo.model.ConfigChange;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloConfigChangeListener;
import com.fshows.fsframework.common.exception.CommonException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.aliyun.oss.FsOssConfig;
import com.fshows.fsframework.extend.util.FsAESUtil;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FsOssClient
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(FsOssClient.class);
    private ApplicationContext applicationContext;
    private FsOssConfig fsOssConfig;
    private static final String BACKSLASH = "/";
    private String decryptAccess;
    private String decryptSecret;
    private volatile OSSClient outOssClient;
    private volatile OSSClient innerOssClient;
    private final ScheduledExecutorService executorService = Executors.newScheduledThreadPool(1);

    @PostConstruct
    public void init() {
        try {
            if (this.fsOssConfig == null) {
                this.fsOssConfig = new FsOssConfig();
            }
            this.fsOssConfig.setApplicationContext(this.applicationContext);
            this.decryptAccess = this.decryptAkAndSk(this.fsOssConfig.getEncryAccessKey(), this.fsOssConfig.getAesPassword());
            this.decryptSecret = this.decryptAkAndSk(this.fsOssConfig.getEncrySecretKey(), this.fsOssConfig.getAesPassword());
            ClientConfiguration config = this.buildOssConfig();
            if (this.outOssClient == null) {
                this.outOssClient = new OSSClient(this.fsOssConfig.getOssEndPointOut(), this.decryptAccess, this.decryptSecret, config);
            }
            if (this.innerOssClient == null) {
                this.innerOssClient = new OSSClient(this.fsOssConfig.getOssEndPointInner(), this.decryptAccess, this.decryptSecret, config);
            }
            LogUtil.info((Logger)log, (String)"FsOssClient\u521d\u59cb\u5316\u5b8c\u6210");
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"FsOssClient\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5AKSK\u662f\u5426\u914d\u7f6e\u6b63\u786e", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApolloConfigChangeListener
    public synchronized void refreshOssClient(ConfigChangeEvent changeEvent) {
        if (!this.fsOssConfig.getOssClientDynamicUpdate().booleanValue()) {
            LogUtil.info((Logger)log, (String)"refreshOssClient >> \u963f\u6ce2\u7f57\u914d\u7f6e\u66f4\u65b0\uff0c\u4f46\u5f53\u524d\u672a\u5f00\u542f\u52a8\u6001\u66f4\u65b0");
            return;
        }
        ConfigChange accessConfigChange = changeEvent.getChange(this.fsOssConfig.getApolloKeyForEncryAccessKey());
        ConfigChange secretConfigChange = changeEvent.getChange(this.fsOssConfig.getApolloKeyForEncrySecretKey());
        LogUtil.info((Logger)log, (String)"refreshOssClient >> \u63a5\u6536\u5230AKSK\u53d8\u6362\u901a\u77e5 >> accessConfigChange={}, secretConfigChange={}", (Object[])new Object[]{accessConfigChange, secretConfigChange});
        String refreshEncryAccessKey = this.fsOssConfig.getEncryAccessKey();
        String refreshEncrySecretKey = this.fsOssConfig.getEncrySecretKey();
        if (accessConfigChange == null && secretConfigChange == null) {
            LogUtil.info((Logger)log, (String)"refreshOssClient >> \u963f\u6ce2\u7f57\u914d\u7f6e\u66f4\u65b0\uff0c\u4f46\u672a\u68c0\u6d4b\u5230AKSK\u53d8\u5316,\u672c\u6b21\u4e0d\u505a\u5904\u7406\u3002");
            return;
        }
        if (accessConfigChange != null && !accessConfigChange.getChangeType().equals((Object)PropertyChangeType.DELETED) && !accessConfigChange.getOldValue().equals(accessConfigChange.getNewValue())) {
            refreshEncryAccessKey = accessConfigChange.getNewValue();
        }
        if (secretConfigChange != null && !secretConfigChange.getChangeType().equals((Object)PropertyChangeType.DELETED) && !secretConfigChange.getOldValue().equals(secretConfigChange.getNewValue())) {
            refreshEncrySecretKey = secretConfigChange.getNewValue();
        }
        boolean newSuccess = false;
        OSSClient tmpOutOssClient = this.outOssClient;
        OSSClient tmpInnerOssClient = this.innerOssClient;
        try {
            this.decryptAccess = this.decryptAkAndSk(refreshEncryAccessKey, this.fsOssConfig.getAesPassword());
            this.decryptSecret = this.decryptAkAndSk(refreshEncrySecretKey, this.fsOssConfig.getAesPassword());
            ClientConfiguration config = this.buildOssConfig();
            this.outOssClient = new OSSClient(this.fsOssConfig.getOssEndPointOut(), this.decryptAccess, this.decryptSecret, config);
            this.innerOssClient = new OSSClient(this.fsOssConfig.getOssEndPointInner(), this.decryptAccess, this.decryptSecret, config);
            LogUtil.info((Logger)log, (String)"refreshOssClient >> OSS\u52a8\u6001\u66ff\u6362aksk\u6210\u529f\uff0c\u65b0OSS\u5ba2\u6237\u7aef\u521b\u5efa\u5b8c\u6210");
            newSuccess = true;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"refreshOssClient >> OSS\u52a8\u6001\u66ff\u6362aksk\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (newSuccess) {
                this.executorService.schedule(() -> {
                    if (!Objects.equals(tmpOutOssClient, this.outOssClient)) {
                        tmpOutOssClient.shutdown();
                        LogUtil.info((Logger)log, (String)"refreshOssClient >> \u65e7\u5ba2\u6237\u7aef(\u5916\u7f51)\u5173\u95ed\u5b8c\u6210");
                    }
                    if (!Objects.equals(tmpInnerOssClient, this.innerOssClient)) {
                        tmpInnerOssClient.shutdown();
                        LogUtil.info((Logger)log, (String)"refreshOssClient >> \u65e7\u5ba2\u6237\u7aef(\u5185\u7f51)\u5173\u95ed\u5b8c\u6210");
                    }
                }, (long)this.fsOssConfig.getCloseDelayTime().intValue(), TimeUnit.SECONDS);
            }
        }
    }

    public String decryptAkAndSk(String ciphertext, String pwd) {
        if (StringUtils.length((CharSequence)ciphertext) < 32) {
            return ciphertext;
        }
        return FsAESUtil.decryptKey(ciphertext, pwd);
    }

    private ClientConfiguration buildOssConfig() {
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMaxConnections(200);
        conf.setSocketTimeout(10000);
        conf.setConnectionTimeout(10000);
        conf.setConnectionRequestTimeout(1000);
        conf.setIdleConnectionTime(10000L);
        conf.setMaxErrorRetry(3);
        conf.setSupportCname(true);
        conf.setSLDEnabled(false);
        conf.setProtocol(Protocol.HTTP);
        return conf;
    }

    public PutObjectResult uploadFileWithOutFlag(String bucketName, String key, InputStream inputStream, boolean outOssFlag) {
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient bucketName is null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outOssFlag) {
            return this.outOssClient.putObject(bucketName, key, inputStream);
        }
        return this.innerOssClient.putObject(bucketName, key, inputStream);
    }

    public PutObjectResult uploadFileWithOutFlag(String bucketName, String key, File file, boolean outOssFlag) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outOssFlag) {
            return this.outOssClient.putObject(bucketName, key, file);
        }
        return this.innerOssClient.putObject(bucketName, key, file);
    }

    public PutObjectResult uploadFileWithOutFlag(String bucketName, String key, String filePath, boolean outOssFlag) {
        return this.uploadFileWithOutFlag(bucketName, key, new File(filePath), outOssFlag);
    }

    public PutObjectResult uploadFile(String bucketName, String key, String filePath) {
        return this.uploadFileWithOutFlag(bucketName, key, new File(filePath), (boolean)this.fsOssConfig.getOssOutClientFlag());
    }

    public PutObjectResult uploadFile(String bucketName, String key, File file) {
        return this.uploadFileWithOutFlag(bucketName, key, file, (boolean)this.fsOssConfig.getOssOutClientFlag());
    }

    public PutObjectResult uploadFile(String bucketName, String key, InputStream inputStream) {
        return this.uploadFileWithOutFlag(bucketName, key, inputStream, (boolean)this.fsOssConfig.getOssOutClientFlag());
    }

    public PutObjectResult uploadFile(String bucketName, String key, String filePath, ObjectMetadata metadata) {
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient bucketName is null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        File file = new File(filePath);
        return this.innerOssClient.putObject(bucketName, key, file, metadata);
    }

    public void downloadFileWithOutFlag(String bucketName, String key, File file, boolean outOssFlag) {
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient bucketName is null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outOssFlag) {
            this.outOssClient.getObject(new GetObjectRequest(bucketName, key), file);
        } else {
            this.innerOssClient.getObject(new GetObjectRequest(bucketName, key), file);
        }
    }

    public void downloadFileWithOutFlag(String bucketName, String key, String filePath, boolean outOssFlag) {
        this.downloadFileWithOutFlag(bucketName, key, new File(filePath), outOssFlag);
    }

    public void downloadFile(String bucketName, String key, String filePath) {
        this.downloadFileWithOutFlag(bucketName, key, new File(filePath), (boolean)this.fsOssConfig.getOssOutClientFlag());
    }

    public void downloadFile(String bucketName, String key, File file) {
        this.downloadFileWithOutFlag(bucketName, key, file, (boolean)this.fsOssConfig.getOssOutClientFlag());
    }

    public String generateFileUrlWithExpireTime(String bucketName, String key, Long expireTime) {
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient bucketName is null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        Date time = new Date(System.currentTimeMillis() + (Objects.isNull(expireTime) ? (long)this.fsOssConfig.getUrlExpireTime().intValue() : expireTime) * 1000L);
        return this.outOssClient.generatePresignedUrl(bucketName, key, time).toString();
    }

    public String generateFileUrl(String bucketName, String key) {
        return this.generateFileUrlWithExpireTime(bucketName, key, null);
    }

    public URL generatePresignedUrl(GeneratePresignedUrlRequest request) {
        return this.outOssClient.generatePresignedUrl(request);
    }

    public void deleteFile(String bucketName, String key) {
        this.deleteFileWithOutOssFlag(bucketName, key, this.fsOssConfig.getOssOutClientFlag());
    }

    public void deleteFileWithOutOssFlag(String bucketName, String key, boolean outOssFlag) {
        if (StringUtils.isEmpty((CharSequence)bucketName)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient bucketName is null", new Object[0]);
        }
        if (StringUtils.isEmpty((CharSequence)key)) {
            throw CommonException.INVALID_PARAM_ERROR.newInstance("FsOssClient key is null", new Object[0]);
        }
        if (key.startsWith(BACKSLASH)) {
            key = key.substring(1);
        }
        if (outOssFlag) {
            this.outOssClient.deleteObject(bucketName, key);
        } else {
            this.innerOssClient.deleteObject(bucketName, key);
        }
    }

    public String generatePostPolicy(Date expiration, PolicyConditions conds) {
        return this.outOssClient.generatePostPolicy(expiration, conds);
    }

    public String calculatePostSignature(String postPolicy) {
        return this.outOssClient.calculatePostSignature(postPolicy);
    }

    public String getAccessKey() {
        return this.decryptAccess;
    }

    public String getOssEndPointOut() {
        return this.fsOssConfig.getOssEndPointOut();
    }

    public String getOssEndPointInner() {
        return this.fsOssConfig.getOssEndPointInner();
    }

    public static void main(String[] args) {
        byte[] md5SecretKey = DigestUtil.md5((byte[])DigestUtil.md5((byte[])"406c42688e7f7db4a8f3912772725a5d".getBytes(StandardCharsets.UTF_8)));
        System.out.println("password md5: " + new String(HexUtil.encodeHex((byte[])md5SecretKey)));
        AES aes = SecureUtil.aes((byte[])md5SecretKey);
        String accessKey = "LTAI5tHpkPpUwR9Pu3xHFUJV";
        String secretKey = "dOj8EqSma1moEQqmKdJb7sb0Pes8OI";
        String encryAccessKey = Base64.encode((byte[])aes.encrypt(accessKey));
        String encrySecretKey = Base64.encode((byte[])aes.encrypt(secretKey));
        System.out.println("oss accessKey encode: " + new String(HexUtil.encodeHex((byte[])Base64.decode((String)encryAccessKey))));
        System.out.println("oss accessKey encode: " + new String(HexUtil.encodeHex((byte[])Base64.decode((String)encrySecretKey))));
        String decryptAccessKey = new String(aes.decrypt(Base64.decode((String)encryAccessKey)));
        String decryptSecretKey = new String(aes.decrypt(Base64.decode((String)encrySecretKey)));
        System.out.println("oss accessKey decode: " + decryptAccessKey);
        System.out.println("oss secretKey decode: " + decryptSecretKey);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setFsOssConfig(FsOssConfig fsOssConfig) {
        this.fsOssConfig = fsOssConfig;
    }
}

