/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.mq.decorator;

import com.aliyun.openservices.ons.api.Message;
import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.SendCallback;
import com.aliyun.openservices.ons.api.SendResult;
import com.aliyun.openservices.ons.api.exception.ONSClientException;
import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.aliyun.mq.config.FsMqConfig;
import com.fshows.fsframework.extend.aliyun.mq.core.FsMqInstanceManager;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FsProducerBean
implements Producer {
    private static final Logger log = LoggerFactory.getLogger(FsProducerBean.class);
    private Properties properties;
    private volatile Producer producer;
    private String instanceKey;
    @Autowired
    private FsMqInstanceManager instanceManager;
    @Autowired
    private FsMqConfig fsMqConfig;

    public void start() {
        if (null == this.instanceManager) {
            throw new ONSClientException("FsMqInstanceManager >> \u5f53\u524d FsProducerBean \u5bf9\u8c61\uff0c\u672a\u901a\u8fc7 @Bean \u6ce8\u89e3\u6ce8\u518c\u5230Spring\u5bb9\u5668\u4e2d, \u542f\u52a8\u5931\u8d25");
        }
        if (null == this.fsMqConfig) {
            throw new ONSClientException("FsMqInstanceManager >> \u5f53\u524d FsProducerBean \u5bf9\u8c61\uff0c\u672a\u901a\u8fc7 @Bean \u6ce8\u89e3\u6ce8\u518c\u5230Spring\u5bb9\u5668\u4e2d, \u542f\u52a8\u5931\u8d25");
        }
        if (null == this.properties) {
            throw new ONSClientException("FsMqInstanceManager >> properties not set");
        }
        this.validateCredentials();
        Properties updatedProperties = this.updatePropertiesWithDecryptedKeys();
        this.producer = ONSFactory.createProducer((Properties)updatedProperties);
        this.producer.start();
        this.instanceKey = this.generateInstanceKey(this.properties);
        if (this.instanceManager != null && this.fsMqConfig != null && this.fsMqConfig.getMqClientDynamicUpdate().booleanValue()) {
            this.instanceManager.registerProducer(this.instanceKey, this, this.properties);
        }
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> FsProducerBean\u542f\u52a8\u5b8c\u6210: {}", (Object[])new Object[]{this.instanceKey});
    }

    public synchronized Producer replaceProducerInstance(Producer newProducer) {
        Producer oldProducer = this.producer;
        this.producer = newProducer;
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> Producer\u5b9e\u4f8b\u5df2\u66ff\u6362: {}", (Object[])new Object[]{this.instanceKey});
        return oldProducer;
    }

    public void shutdown() {
        if (this.instanceManager != null && this.instanceKey != null) {
            this.instanceManager.unregisterProducer(this.instanceKey);
        }
        if (this.producer != null) {
            this.producer.shutdown();
        }
        LogUtil.info((Logger)log, (String)"FsMqInstanceManager >> FsProducerBean\u5df2\u5173\u95ed: {}", (Object[])new Object[]{this.instanceKey});
    }

    @PreDestroy
    public void preDestroy() {
        this.shutdown();
    }

    public void updateCredential(Properties credentialProperties) {
        if (this.producer != null) {
            this.producer.updateCredential(credentialProperties);
        }
    }

    public SendResult send(Message message) {
        return this.producer.send(message);
    }

    public void sendOneway(Message message) {
        this.producer.sendOneway(message);
    }

    public void sendAsync(Message message, SendCallback sendCallback) {
        this.producer.sendAsync(message, sendCallback);
    }

    public void setCallbackExecutor(ExecutorService callbackExecutor) {
        this.producer.setCallbackExecutor(callbackExecutor);
    }

    public boolean isStarted() {
        return this.producer != null && this.producer.isStarted();
    }

    public boolean isClosed() {
        return this.producer == null || this.producer.isClosed();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private Properties updatePropertiesWithDecryptedKeys() {
        Properties updatedProperties = new Properties();
        updatedProperties.putAll((Map<?, ?>)this.properties);
        if (this.fsMqConfig != null && this.fsMqConfig.getMqClientDynamicUpdate().booleanValue()) {
            updatedProperties.setProperty("AccessKey", this.fsMqConfig.getDecryptedAccessKey());
            updatedProperties.setProperty("SecretKey", this.fsMqConfig.getDecryptedSecretKey());
        }
        return updatedProperties;
    }

    private void validateCredentials() {
        String accessKey = this.properties.getProperty("AccessKey");
        String secretKey = this.properties.getProperty("SecretKey");
        if (accessKey != null || secretKey != null) {
            String producerId = this.properties.getProperty("ProducerId");
            if (StringUtils.isBlank((CharSequence)producerId)) {
                producerId = this.properties.getProperty("GROUP_ID");
            }
            String errorMsg = String.format("%s\u751f\u4ea7\u8005\u5b9e\u4f8b\u542f\u52a8\u5931\u8d25\uff0c\u963f\u91cc\u4e91ak\u548csk\u8bbe\u7f6e\u5fc5\u987b\u4e3a\u7a7a\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u4f7f\u7528\u7edf\u4e00\u914d\u7f6eak/sk\u914d\u7f6e", producerId);
            LogUtil.error((Logger)log, (String)errorMsg);
            throw new ONSClientException(errorMsg);
        }
    }

    private String generateInstanceKey(Properties properties) {
        String groupId = properties.getProperty("GROUP_ID");
        if (StringUtils.isBlank((CharSequence)groupId)) {
            groupId = properties.getProperty("ConsumerId");
        }
        if (StringUtils.isBlank((CharSequence)groupId)) {
            groupId = "UNKNOW_GROUP_ID";
        }
        return "producer_" + groupId + "_" + System.identityHashCode(this) + "_" + System.currentTimeMillis();
    }
}

