/**
 * fshows.com
 * Copyright (C) 2013-2019 All Rights Reserved.
 */
package com.fshows.fsframework.extend.util;

import com.fshows.fsframework.common.exception.CommonException;
import org.springframework.context.ApplicationContext;
import org.springframework.util.StringUtils;

/**
 * spring配置获取工具
 *
 * @author Liluqing
 * @version SpringPropertyUtil.java, v 0.1 2019-09-20 10:31
 */
public class ConfigUtil {


    /**
     * 动态属性前缀
     */
    public final static String DYNAMIC_PROPERTY_PREFIX = "${";

    /**
     * 动态属性前缀2
     */
    public final static String DYNAMIC_PROPERTY_PREFIX2 = "#{";

    /**
     * 动态属性后缀
     */
    public final static String DYNAMIC_PROPERTY_SUFFIX = "}";

    /**
     * 阿里云的主域名
     */
    public final static String ALIYUN_DOMAIN_NAME ="aliyuncs.com";

    /**
     * none
     */
    public final static String NONE = "none";

    /**
     * 获取配置
     *
     * @param el
     * @return
     */
    public static String getProperty(String el, ApplicationContext ctx) {
        if (isDynamicProperty(el)) {
            String result = ctx.getEnvironment().resolveRequiredPlaceholders(el);
            return isDynamicProperty(result) ? null : result;
        }
        return el;
    }


    /**
     * 获取配置
     *
     * @param el
     * @return
     */
    public static <T> T getProperty(String el, Class<T> targetType, ApplicationContext ctx) {
        if (el == null) {
            return null;
        }
        String value = getProperty(el, ctx);
        // 类型转换
        if (targetType == String.class) {
            return (T) value;
        } else if (targetType == Boolean.class) {
            return (T) Boolean.valueOf(value);
        } else if (targetType == Integer.class) {
            return (T) Integer.valueOf(value);
        } else if (targetType == Long.class) {
            return (T) Long.valueOf(value);
        }
        throw CommonException.SYSTEM_ERROR.newInstance("spring配置获取失败，不支持的参数类型：" + value);
    }

    /**
     * 是否外部动态配置
     *
     * @return
     */
    public static boolean isDynamicProperty(String key) {
        if (StringUtils.startsWithIgnoreCase(key, DYNAMIC_PROPERTY_PREFIX2)
                && StringUtils.endsWithIgnoreCase(key, DYNAMIC_PROPERTY_SUFFIX)) {
            return true;
        }
        return StringUtils.startsWithIgnoreCase(key, DYNAMIC_PROPERTY_PREFIX)
                && StringUtils.endsWithIgnoreCase(key, DYNAMIC_PROPERTY_SUFFIX);
    }

    /**
     * 获取动态配置的key的值
     *  例如:  入参 ${fs.oss.endpoint.inner:xxxxx}  返回 fs.oss.endpoint.inner
     *
     * @param el
     * @return
     */
    public static String getDynamicConfigKey(String el) {
        return isDynamicProperty(el) ? el : null;
    }

    /**
     * 获取配置的键名
     *
     * @param key
     * @return
     */
    public static String getDynamicKey(String key) {
        if (isDynamicProperty(key)) {
            int i = key.indexOf(":");
            if (i > -1) {
                return key.substring(2, i);
            }
            return key.substring(2, key.length() - 1);
        }
        return null;
    }
}