/**
 * fshows.com
 * Copyright (C) 2013-2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.aliyun.event;

import lombok.Data;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

/**
 *
 * @author liujing01
 * @version AliyunEventPO.java, v 0.1 2018-09-25 14:34 
 */
@Data
public class EventEntry implements java.io.Serializable{

    private static final long serialVersionUID = 2017035653587412576L;
    /**
     * 事件详情
     */
    private String content;
    /**
     * 事件所属的应用分组Id
     */
    private long groupId;
    /**
     * 事件名称
     */
    private String name;


    public EventEntry(String content, long groupId, String name) {
        this.content = content;
        this.groupId = groupId;
        this.name = name;
    }

    public EventEntry(){

    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}
