/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.lock;

import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.core.utils.SystemClock;
import com.fshows.fsframework.extend.lock.DistributedLockManager;
import com.fshows.fsframework.extend.lock.LockServiceHandle;
import com.fshows.fsframework.extend.lock.exception.RedisTryLockException;
import com.fshows.fsframework.extend.redis.RedisCache;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.redisson.api.RLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisDistributedLockManagerImpl
implements DistributedLockManager {
    private static final Logger log = LoggerFactory.getLogger(RedisDistributedLockManagerImpl.class);
    private RedisCache redisCache;
    private static final long DEFAULT_TRY_WAIT_TIME = 3000L;
    private static final long DEFAULT_EXPIRE_TIME = 10000L;

    @Override
    public <T> T execute(String lockKey, Supplier<T> serviceHandle) {
        return this.execute(lockKey, 3000L, 10000L, serviceHandle);
    }

    @Override
    public <T> T execute(String lockKey, long tryWaitTime, Supplier<T> serviceHandle) {
        return this.execute(lockKey, tryWaitTime, 10000L, serviceHandle);
    }

    @Override
    public <T> T execute(String lockKey, long tryWaitTime, long expireTime, Supplier<T> serviceHandle) {
        T result;
        long currentTime = SystemClock.millisClock().now();
        RLock lock = null;
        try {
            lock = this.trylock(lockKey, tryWaitTime, expireTime);
            result = serviceHandle.get();
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"execute >> \u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011\u4e1a\u52a1\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38\uff01lockKey = {}", (Throwable)e, (Object[])new Object[]{lockKey});
            throw e;
        }
        finally {
            this.unlock(lock, lockKey, currentTime);
        }
        return result;
    }

    @Override
    public void executeNoReturn(String lockKey, LockServiceHandle serviceHandle) {
        this.executeNoReturn(lockKey, 3000L, 10000L, serviceHandle);
    }

    @Override
    public void executeNoReturn(String lockKey, long tryWaitTime, LockServiceHandle serviceHandle) {
        this.executeNoReturn(lockKey, tryWaitTime, 10000L, serviceHandle);
    }

    @Override
    public void executeNoReturn(String lockKey, long tryWaitTime, long expireTime, LockServiceHandle serviceHandle) {
        long currentTime = SystemClock.millisClock().now();
        RLock lock = null;
        try {
            lock = this.trylock(lockKey, tryWaitTime, expireTime);
            serviceHandle.handle();
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"executeNoReturn >> \u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011\u4e1a\u52a1\u64cd\u4f5c\u51fa\u73b0\u5f02\u5e38\uff01lockKey = {}", (Throwable)e, (Object[])new Object[]{lockKey});
            throw e;
        }
        finally {
            this.unlock(lock, lockKey, currentTime);
        }
    }

    private RLock trylock(String lockKey, long tryWaitTime, long expireTime) {
        RLock lock;
        try {
            lock = this.redisCache.getRedisLock(lockKey);
            boolean isSuccess = lock.tryLock(tryWaitTime, expireTime, TimeUnit.MILLISECONDS);
            if (!isSuccess) {
                LogUtil.info((Logger)log, (String)"\u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011trylock-\u52a0\u9501\u5931\u8d25,\u9501\u88ab\u5176\u4ed6\u7ebf\u7a0b\u5360\u7528\uff01lockKey = {}", (Object[])new Object[]{lockKey});
                throw new RedisTryLockException();
            }
            LogUtil.info((Logger)log, (String)"\u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011\u52a0\u9501\u6210\u529f\uff01lockKey = {}", (Object[])new Object[]{lockKey});
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011trylock-\u52a0\u9501\u5931\u8d25\uff01lockKey = {}", (Throwable)e, (Object[])new Object[]{lockKey});
            throw new RedisTryLockException("redis\u52a0\u9501\u5931\u8d25", e);
        }
        return lock;
    }

    private boolean unlock(RLock lock, String lockKey, long lockStartTime) {
        if (null == lock) {
            return false;
        }
        try {
            lock.unlock();
            LogUtil.info((Logger)log, (String)"\u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011\u89e3\u9501\u6210\u529f\uff01lockKey = {},\u9501\u6301\u7eed\u65f6\u95f4={}ms", (Object[])new Object[]{lockKey, SystemClock.millisClock().now() - lockStartTime});
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"\u3010redis\u5206\u5e03\u5f0f\u9501\u670d\u52a1\u3011unlock-\u89e3\u9501\u5931\u8d25\uff01lockKey = {}", (Throwable)e, (Object[])new Object[]{lockKey});
            return true;
        }
        return true;
    }

    public void setRedisCache(RedisCache redisCache) {
        this.redisCache = redisCache;
    }
}

