/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.idgen.worker.repos;

import com.fshows.fsframework.core.utils.LogUtil;
import com.fshows.fsframework.extend.idgen.cache.WorkerIdFileCache;
import com.fshows.fsframework.extend.idgen.exception.WorkerIdAssignException;
import com.fshows.fsframework.extend.idgen.worker.WorkerNode;
import com.fshows.fsframework.extend.idgen.worker.repos.WorkerNodeRepository;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWorkerNodeRepository
implements WorkerNodeRepository {
    private static final Logger log = LoggerFactory.getLogger(BaseWorkerNodeRepository.class);
    private static final Long DEFAULT_WORKER_ID = 1L;

    @Override
    public final synchronized long assignWorkerId(String ipAddress, String appName) {
        try {
            WorkerNode workerNode = this.get(ipAddress, appName);
            if (workerNode == null) {
                workerNode = new WorkerNode();
                workerNode.setAppName(appName);
                workerNode.setCreated(new Date());
                workerNode.setModified(new Date());
                workerNode.setHostName(ipAddress);
                workerNode.setWorkerId(DEFAULT_WORKER_ID);
                this.insert(workerNode);
            }
            WorkerIdFileCache.writeCache(appName, workerNode);
            return workerNode.getWorkerId();
        }
        catch (Exception ex) {
            LogUtil.error((Logger)log, (String)"assign worker id error ", (Throwable)ex);
            WorkerNode cachedWorkNode = (WorkerNode)WorkerIdFileCache.getDataFromFile(appName);
            if (cachedWorkNode != null) {
                return cachedWorkNode.getWorkerId();
            }
            throw new WorkerIdAssignException(ex.getMessage(), ex);
        }
    }

    public abstract void insert(WorkerNode var1);

    public abstract WorkerNode get(String var1, String var2);
}

