/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.aliyun.oss;

import com.fshows.fsframework.extend.util.ConfigUtil;
import javax.validation.constraints.NotNull;
import org.springframework.context.ApplicationContext;

public class FsOssConfig {
    private ApplicationContext applicationContext;
    @NotNull
    private String aesPassword = "${fs.aliyun.key.aes.encry.password}";
    @NotNull
    private String encryAccessKey = "${fs.aliyun.oss.access.key}";
    @NotNull
    private String encrySecretKey = "${fs.aliyun.oss.secret.key}";
    private String ossOutClientFlag = "${fs.aliyun.oss.out.client.flag:false}";
    private String ossEndPointOut = "${fs.aliyun.oss.out.url:https://oss-cn-hangzhou.aliyuncs.com}";
    private String ossEndPointInner = "${fs.aliyun.oss.inner.url:https://oss-cn-hangzhou-internal.aliyuncs.com}";
    private String urlExpireTime = "${fs.aliyun.oss.url.expire.time:3600}";
    private String closeDelayTime = "${fs.aliyun.oss.close.delay.time:30}";

    public Boolean getOssOutClientFlag() {
        return ConfigUtil.getProperty(this.ossOutClientFlag, Boolean.class, this.applicationContext);
    }

    public String getOssEndPointOut() {
        return ConfigUtil.getProperty(this.ossEndPointOut, this.applicationContext);
    }

    public String getOssEndPointInner() {
        return ConfigUtil.getProperty(this.ossEndPointInner, this.applicationContext);
    }

    public Integer getUrlExpireTime() {
        return ConfigUtil.getProperty(this.urlExpireTime, Integer.class, this.applicationContext);
    }

    public Integer getCloseDelayTime() {
        return ConfigUtil.getProperty(this.closeDelayTime, Integer.class, this.applicationContext);
    }

    public String getAesPassword() {
        return ConfigUtil.getProperty(this.aesPassword, this.applicationContext);
    }

    public String getEncryAccessKey() {
        return ConfigUtil.getProperty(this.encryAccessKey, this.applicationContext);
    }

    public String getApolloKeyForEncrySecretKey() {
        return ConfigUtil.getDynamicKey(this.encrySecretKey);
    }

    public String getApolloKeyForEncryAccessKey() {
        return ConfigUtil.getDynamicKey(this.encryAccessKey);
    }

    public String getEncrySecretKey() {
        return ConfigUtil.getProperty(this.encrySecretKey, this.applicationContext);
    }

    public Boolean getOssClientDynamicUpdate() {
        return ConfigUtil.isDynamicProperty(this.encryAccessKey) && ConfigUtil.isDynamicProperty(this.encrySecretKey);
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setAesPassword(String aesPassword) {
        this.aesPassword = aesPassword;
    }

    public void setEncryAccessKey(String encryAccessKey) {
        this.encryAccessKey = encryAccessKey;
    }

    public void setEncrySecretKey(String encrySecretKey) {
        this.encrySecretKey = encrySecretKey;
    }

    public void setOssOutClientFlag(String ossOutClientFlag) {
        this.ossOutClientFlag = ossOutClientFlag;
    }

    public void setOssEndPointOut(String ossEndPointOut) {
        this.ossEndPointOut = ossEndPointOut;
    }

    public void setOssEndPointInner(String ossEndPointInner) {
        this.ossEndPointInner = ossEndPointInner;
    }

    public void setUrlExpireTime(String urlExpireTime) {
        this.urlExpireTime = urlExpireTime;
    }

    public void setCloseDelayTime(String closeDelayTime) {
        this.closeDelayTime = closeDelayTime;
    }
}

