/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.extend.transaction;

import com.fshows.fsframework.core.annotation.CustomTransaction;
import com.fshows.fsframework.extend.util.SpringContextUtil;
import java.util.Stack;
import org.apache.commons.lang3.ArrayUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
@Aspect
public class SpringTransactionAop {
    @Pointcut(value="@annotation(com.fshows.fsframework.core.annotation.CustomTransaction)")
    public void pointCut() {
    }

    @Around(value="pointCut()&&@annotation(annotation)")
    public Object twiceAsOld(ProceedingJoinPoint point, CustomTransaction annotation) throws Throwable {
        Stack<DataSourceTransactionManager> dataSourceTransactionManagerStack = new Stack<DataSourceTransactionManager>();
        Stack<TransactionStatus> transactionStatusStack = new Stack<TransactionStatus>();
        try {
            if (!this.openTransaction(dataSourceTransactionManagerStack, transactionStatusStack, annotation)) {
                return null;
            }
            Object ret = point.proceed();
            this.commit(dataSourceTransactionManagerStack, transactionStatusStack);
            return ret;
        }
        catch (Throwable e) {
            this.rollback(dataSourceTransactionManagerStack, transactionStatusStack);
            throw e;
        }
    }

    private boolean openTransaction(Stack<DataSourceTransactionManager> dataSourceTransactionManagerStack, Stack<TransactionStatus> transactionStatusStack, CustomTransaction multiTransactional) {
        String[] transactionMangerNames = multiTransactional.name();
        if (ArrayUtils.isEmpty((Object[])multiTransactional.name())) {
            return false;
        }
        for (String beanName : transactionMangerNames) {
            DataSourceTransactionManager dataSourceTransactionManager = SpringContextUtil.getBean(beanName, DataSourceTransactionManager.class);
            TransactionStatus transactionStatus = dataSourceTransactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition());
            transactionStatusStack.push(transactionStatus);
            dataSourceTransactionManagerStack.push(dataSourceTransactionManager);
        }
        return true;
    }

    private void commit(Stack<DataSourceTransactionManager> dataSourceTransactionManagerStack, Stack<TransactionStatus> transactionStatusStack) {
        while (!dataSourceTransactionManagerStack.isEmpty()) {
            dataSourceTransactionManagerStack.pop().commit(transactionStatusStack.pop());
        }
    }

    private void rollback(Stack<DataSourceTransactionManager> dataSourceTransactionManagerStack, Stack<TransactionStatus> transactionStatusStack) {
        while (!dataSourceTransactionManagerStack.isEmpty()) {
            dataSourceTransactionManagerStack.pop().rollback(transactionStatusStack.pop());
        }
    }
}

