/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.fsframework.extend.util;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.digest.DigestUtil;
import cn.hutool.crypto.symmetric.AES;

import java.nio.charset.StandardCharsets;

/**
 * @author wangqilei
 * @version FsAESUtil.java, v 0.1 2024-12-11 3:53 PM wangqilei
 */
public class FsAESUtil {

    /**
     * AES密码加密
     */
    public static byte[] generateAESPwd(String pwd) {
        return DigestUtil.md5(DigestUtil.md5(pwd.getBytes(StandardCharsets.UTF_8)));
    }

    /**
     * AES解密
     */
    public static String decryptKey(String ciphertext, String pwd) {
        AES aes = SecureUtil.aes(generateAESPwd(pwd));
        return new String(aes.decrypt(ciphertext));
    }
}