/**
 * Zentech-Inc
 * Copyright (C) 2018 All Rights Reserved.
 */
package com.fshows.fsframework.extend.lock.exception;

/**
 * @author wujn
 * @version $Id WorkerIdAssignException.java, v 0.1 2018-02-01 14:58
 */
public class ZookeeperLockException extends LockException {

    private static final long serialVersionUID = -7784521238814676157L;
    /**
     * Default constructor
     */
    public ZookeeperLockException() {
        super();
    }

    /**
     * Constructor with message & cause
     *
     * @param message
     * @param cause
     */
    public ZookeeperLockException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructor with message
     *
     * @param message
     */
    public ZookeeperLockException(String message) {
        super(message);
    }

    /**
     * Constructor with message format
     *
     * @param msgFormat
     * @param args
     */
    public ZookeeperLockException(String msgFormat, Object... args) {
        super(String.format(msgFormat, args));
    }

    /**
     * Constructor with cause
     *
     * @param cause
     */
    public ZookeeperLockException(Throwable cause) {
        super(cause);
    }
}
