/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.fsframework.extend.extension.context;

import com.fshows.fsframework.extend.extension.BusinessScenario;
import com.fshows.fsframework.extend.extension.factory.ExtensionFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * 上下文及扩展点组件工厂的持有类
 * @author liangyuanping
 * @version ExtensionContextHolder.java, v 0.1 2022-07-16 7:35 下午 liangyuanping
 */
@Component
@Slf4j
public class ExtensionContextHolder implements ExtensionContext {

    @Resource
    private ExtensionFactory extensionFactory;

    @Override
    public <T> T getPoint(BusinessScenario businessScenario, Class<T> clazz) {
        return extensionFactory.get(businessScenario, clazz);
    }
}