package com.fshows.fsframework.extend.dubbo.model;

import lombok.Data;

import java.time.LocalTime;
import java.util.List;

/**
 * dubbo线程池监控配置model
 *
 * @author zhaoxumin
 * @version DubboThreadPoolMonitorConfigModel.java, v 0.1 2024-08-09 14:00 zhaoxumin
 */
@Data
public class DubboThreadPoolMonitorConfigConvertModel {

    /**
     * 监控点配置列表
     */
    private List<ThreadPoolMonitorPointConfigConvertModel> threadPoolMonitorPointConfigList;

    /**
     * 应用线程数
     */
    private String applicationThreadCount;

    @Data
    public static class ThreadPoolMonitorPointConfigConvertModel {

        /**
         * 监控时间段开始时间. HH:mm:ss
         */
        private LocalTime monitorPeriodStartTime;
        /**
         * 监控时间段结束时间. HH:mm:ss
         */
        private LocalTime monitorPeriodEndTime;

        /**
         * 监控频率. 单位秒
         */
        private Integer monitorFrequency;

        /**
         * 线程池占用阈值
         */
        private String usageThreshold;
    }
}
