package com.fshows.fsframework.extend.dubbo.model;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * dubbo线程池监控配置model
 *
 * @author zhaoxumin
 * @version DubboThreadPoolMonitorConfigModel.java, v 0.1 2024-08-09 14:00 zhaoxumin
 */
@Data
public class DubboThreadPoolMonitorConfigModel {

    /**
     * 监控点配置列表
     */
    private List<ThreadPoolMonitorPointConfigModel> threadPoolMonitorPointConfigModelList;

    /**
     * 应用线程数
     */
    private Integer applicationThreadCount;

    @Data
    public static class ThreadPoolMonitorPointConfigModel {

        /**
         * 监控时间段区间. HH:mm:ss～HH:mm:ss
         */
        private String monitorPeriod;

        /**
         * 监控频率. 单位秒
         */
        private Integer monitorFrequency;

        /**
         * 线程池占用阈值. 数值不大于1，例如0.8
         */
        private String usageThreshold;
    }


    public static void main(String[] args) {
        DubboThreadPoolMonitorConfigModel threadPoolMonitorConfigModel = new DubboThreadPoolMonitorConfigModel();
        threadPoolMonitorConfigModel.setApplicationThreadCount(300);

        List<ThreadPoolMonitorPointConfigModel> threadPoolMonitorPointConfigModelList = Lists.newArrayList();

        ThreadPoolMonitorPointConfigModel threadPoolMonitorPointConfigModel = new ThreadPoolMonitorPointConfigModel();
        threadPoolMonitorPointConfigModel.setMonitorPeriod("11:00:00~11:05:00");
        threadPoolMonitorPointConfigModel.setMonitorFrequency(5);
        threadPoolMonitorPointConfigModel.setUsageThreshold("0.8");
        threadPoolMonitorPointConfigModelList.add(threadPoolMonitorPointConfigModel);

        threadPoolMonitorPointConfigModel = new ThreadPoolMonitorPointConfigModel();
        threadPoolMonitorPointConfigModel.setMonitorPeriod("11:05:00~11:10:00");
        threadPoolMonitorPointConfigModel.setMonitorFrequency(30);
        threadPoolMonitorPointConfigModel.setUsageThreshold("0.8");
        threadPoolMonitorPointConfigModelList.add(threadPoolMonitorPointConfigModel);

        threadPoolMonitorPointConfigModel = new ThreadPoolMonitorPointConfigModel();
        threadPoolMonitorPointConfigModel.setMonitorPeriod("11:10:00~11:20:00");
        threadPoolMonitorPointConfigModel.setMonitorFrequency(10);
        threadPoolMonitorPointConfigModel.setUsageThreshold("0.8");
        threadPoolMonitorPointConfigModelList.add(threadPoolMonitorPointConfigModel);
        threadPoolMonitorConfigModel.setThreadPoolMonitorPointConfigModelList(threadPoolMonitorPointConfigModelList);

        System.out.println(JSON.toJSONString(threadPoolMonitorConfigModel));
    }
}
