package com.fshows.fsframework.extend.dubbo.model;

import com.alibaba.fastjson.JSON;
import com.fshows.fsframework.core.utils.FsDateUtil;
import com.google.common.collect.Lists;
import lombok.Data;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * dubbo线程池监控配置model
 *
 * @author zhaoxumin
 * @version DubboThreadPoolMonitorConfigModel.java, v 0.1 2024-08-09 14:00 zhaoxumin
 */
@Data
public class DubboThreadPoolMonitorConfigConvertModel {

    /**
     * 监控点配置列表
     */
    private List<ThreadPoolMonitorPointConfigConvertModel> threadPoolMonitorPointConfigList;

    /**
     * 应用线程数
     */
    private Integer applicationThreadCount;

    @Data
    public static class ThreadPoolMonitorPointConfigConvertModel {

        /**
         * 监控时间段开始时间. HH:mm:ss
         */
        private LocalTime monitorPeriodStartTime;
        /**
         * 监控时间段结束时间. HH:mm:ss
         */
        private LocalTime monitorPeriodEndTime;

        /**
         * 监控频率. 单位秒
         */
        private Integer monitorFrequency;

        /**
         * 线程池占用阈值
         */
        private float usageThreshold;
    }

    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);

    public static void main(String[] args) {
        DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel();
        threadPoolMonitorConfigConvertModel.setApplicationThreadCount(500);

        List<ThreadPoolMonitorPointConfigConvertModel> threadPoolMonitorPointConfigList = Lists.newArrayList();
        ThreadPoolMonitorPointConfigConvertModel threadPoolMonitorPointConfigConvertModel = new ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(5);

        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("13:30:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("13:40:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);

        threadPoolMonitorPointConfigConvertModel = new ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(30);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("13:40:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("13:50:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);

        threadPoolMonitorPointConfigConvertModel = new ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(10);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("13:50:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("17:00:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);
        threadPoolMonitorConfigConvertModel.setThreadPoolMonitorPointConfigList(threadPoolMonitorPointConfigList);
        System.out.println(JSON.toJSONString(threadPoolMonitorConfigConvertModel));

        for (ThreadPoolMonitorPointConfigConvertModel config : threadPoolMonitorConfigConvertModel.getThreadPoolMonitorPointConfigList()) {
            LocalTime start = config.getMonitorPeriodStartTime();
            LocalTime end = config.getMonitorPeriodEndTime();
            long monitorFrequency = config.getMonitorFrequency();

            // 调度任务
            scheduleTaskAtFixedRate(start, end, monitorFrequency, 100, 0);
        }
        System.out.println("finished");
        return;
    }

    private static void scheduleTaskAtFixedRate(LocalTime start, LocalTime end, long monitorFrequency, Integer applicationThreadCount, float usageThreshold) {
        long initialDelay = 0;
        LocalTime nowTime = LocalTime.now();
        if (nowTime.isBefore(start)) {
            initialDelay = nowTime.until(start, ChronoUnit.SECONDS);
        }

        SCHEDULER.scheduleAtFixedRate(() -> {
            LocalTime now = LocalTime.now();
            if (now.isAfter(start) && now.isBefore(end)) {
                System.out.println(FsDateUtil.format(new Date(), FsDateUtil.SIMPLE_DATETIME_FORMAT));
            }
        }, initialDelay, monitorFrequency, TimeUnit.SECONDS);
    }
}
