package com.fshows.fsframework.extend.dubbo.model;

import com.fshows.fsframework.core.utils.FsDateUtil;
import com.google.common.collect.Lists;
import lombok.Data;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * dubbo方法监控配置model
 *
 * @author zhaoxumin
 * @version DubboMethodMonitorConfigModel.java, v 0.1 2023-06-01 22:27 zhaoxumin
 */
@Data
public class DubboMethodMonitorConfigModel {

    /**
     * 监控点配置列表
     */
    private List<MethodMonitorPointConfigModel> methodMonitorPointConfigList;

    @Data
    public static class MethodMonitorPointConfigModel {

        /**
         * 方法名称. 支持配置多个，以,分隔
         */
        private String methodName;

        /**
         * 监控点配置列表
         */
        private List<MethodMonitorLevelConfigModel> methodMonitorLevelConfigList;
    }

    @Data
    public static class MethodMonitorLevelConfigModel {

        /**
         * 耗时等级
         */
        private String level;

        /**
         * 下限阈值
         */
        private Integer lowerThreshold;
    }

    /**
     * 调度任务执行器
     */
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1);

    public static void main(String[] args) {
        DubboThreadPoolMonitorConfigConvertModel threadPoolMonitorConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel();
        threadPoolMonitorConfigConvertModel.setApplicationThreadCount(500);

        List<DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel> threadPoolMonitorPointConfigList = Lists.newArrayList();
        DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel threadPoolMonitorPointConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(5);

        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("13:30:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("13:40:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);

        threadPoolMonitorPointConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(30);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("13:40:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("13:50:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);

        threadPoolMonitorPointConfigConvertModel = new DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel();
        threadPoolMonitorPointConfigConvertModel.setMonitorFrequency(10);
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodStartTime(LocalTime.parse("13:50:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setMonitorPeriodEndTime(LocalTime.parse("17:00:00", DateTimeFormatter.ofPattern("HH:mm:ss")));
        threadPoolMonitorPointConfigConvertModel.setUsageThreshold(0.8f);
        threadPoolMonitorPointConfigList.add(threadPoolMonitorPointConfigConvertModel);
        threadPoolMonitorConfigConvertModel.setThreadPoolMonitorPointConfigList(threadPoolMonitorPointConfigList);

        for (DubboThreadPoolMonitorConfigConvertModel.ThreadPoolMonitorPointConfigConvertModel configConvertModel : threadPoolMonitorPointConfigList) {
            LocalTime start = configConvertModel.getMonitorPeriodStartTime();
            LocalTime end = configConvertModel.getMonitorPeriodEndTime();
            long monitorFrequency = configConvertModel.getMonitorFrequency();

            // 调度任务
            scheduleTaskAtFixedRate(start, end, monitorFrequency, threadPoolMonitorConfigConvertModel.getApplicationThreadCount(), configConvertModel.getUsageThreshold());
        }
    }

    private static void scheduleTaskAtFixedRate(LocalTime start, LocalTime end, long monitorFrequency, Integer applicationThreadCount, float usageThreshold) {
        long initialDelay = 0;
        LocalTime nowTime = LocalTime.now();
        if (nowTime.isBefore(start)) {
            initialDelay = nowTime.until(start, java.time.temporal.ChronoUnit.SECONDS);
        }

        SCHEDULER.scheduleAtFixedRate(() -> {
            LocalTime now = LocalTime.now();
            if (now.isAfter(start) && now.isBefore(end)) {
                System.out.println(FsDateUtil.format(new Date(), FsDateUtil.SIMPLE_DATETIME_FORMAT));
            }
        }, initialDelay, monitorFrequency, TimeUnit.SECONDS);
    }
}
