/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.common.exception;

import com.fshows.fsframework.common.exception.BaseException;
import java.io.Serializable;
import java.text.MessageFormat;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class ExternalException
extends BaseException
implements Serializable {
    private static final long serialVersionUID = 3261789918591069676L;
    protected String projectId;
    protected String businessType;
    protected String msg;
    protected String code;
    protected String subCode;

    public ExternalException(String code, String msgFormat, Object ... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    public ExternalException(String code, String subCode, String msgFormat, Object ... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.subCode = subCode;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    public ExternalException init(String projectId, String businessType) {
        ExternalException exception = new ExternalException();
        exception.setProjectId(projectId);
        exception.setBusinessType(businessType);
        return exception;
    }

    public ExternalException build(String code, String subCode, String msgFormat, Object ... args) {
        this.code = code;
        this.subCode = subCode;
        this.msg = MessageFormat.format(msgFormat, args);
        return this;
    }

    @Override
    public ExternalException newInstance(String msgFormat, Object ... args) {
        this.msg = MessageFormat.format(msgFormat, args);
        return this;
    }

    public ExternalException() {
    }

    public ExternalException(String message, Throwable cause) {
        super(message, cause);
    }

    public ExternalException(Throwable cause) {
        super(cause);
    }

    public ExternalException(String message) {
        super(message);
    }

    @Override
    public String getSubCode() {
        return this.subCode;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

