/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsframework.common.exception;

import com.fshows.fsframework.common.exception.BaseException;
import java.io.Serializable;
import java.text.MessageFormat;

public class FsInternalException
extends BaseException
implements Serializable {
    private static final long serialVersionUID = -2525983584145264509L;
    protected String projectId;
    protected String businessType;
    protected String msg;
    protected String code;
    protected String subCode;

    public FsInternalException(String code, String msgFormat, Object ... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    public FsInternalException(String code, String subCode, String msgFormat, Object ... args) {
        super(MessageFormat.format(msgFormat, args));
        this.code = code;
        this.subCode = subCode;
        this.msg = MessageFormat.format(msgFormat, args);
    }

    public FsInternalException init(String projectId, String businessType) {
        FsInternalException exception = new FsInternalException();
        exception.setProjectId(projectId);
        exception.setBusinessType(businessType);
        return exception;
    }

    public FsInternalException build(String code, String subCode, String msgFormat, Object ... args) {
        return new FsInternalException(this.code, this.subCode, MessageFormat.format(msgFormat, args), new Object[0]);
    }

    @Override
    public FsInternalException newInstance(String msgFormat, Object ... args) {
        this.msg = MessageFormat.format(msgFormat, args);
        return this;
    }

    public FsInternalException() {
    }

    public FsInternalException(String message, Throwable cause) {
        super(message, cause);
    }

    public FsInternalException(Throwable cause) {
        super(cause);
    }

    public FsInternalException(String message) {
        super(message);
    }

    @Override
    public String getSubCode() {
        return this.subCode;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getMessage() {
        return "[" + this.code + "]" + this.msg;
    }
}

